/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

public class WeightedCanberraDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
WeightedNumberVectorDistanceFunction<NumberVector> {
    protected double[] weights;

    public WeightedCanberraDistanceFunction(double[] weights) {
        this.weights = weights;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = WeightedCanberraDistanceFunction.dimensionality(v1, v2, this.weights.length);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double xd = v1.doubleValue(d);
            double yd = v2.doubleValue(d);
            double div = Math.abs(xd) + Math.abs(yd);
            if (!(div > 0.0)) continue;
            agg += this.weights[d] * Math.abs(xd - yd) / div;
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim = WeightedCanberraDistanceFunction.dimensionality(mbr1, mbr2, this.weights.length);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double diff;
            if (mbr1.getMax(d) < mbr2.getMin(d)) {
                diff = mbr2.getMin(d) - mbr1.getMax(d);
            } else {
                if (!(mbr1.getMin(d) > mbr2.getMax(d))) continue;
                diff = mbr1.getMin(d) - mbr2.getMax(d);
            }
            double a1 = Math.max(-mbr1.getMin(d), mbr1.getMax(d));
            double a2 = Math.max(-mbr2.getMin(d), mbr2.getMax(d));
            double div = a1 + a2;
            agg += this.weights[d] * diff / div;
        }
        return agg;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter weightsP = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (config.grab(weightsP)) {
                this.weights = (double[])((double[])weightsP.getValue()).clone();
            }
        }

        @Override
        protected WeightedCanberraDistanceFunction makeInstance() {
            return new WeightedCanberraDistanceFunction(this.weights);
        }
    }
}

