/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.colorhistogram;

import de.lmu.ifi.dbs.elki.distance.distancefunction.MatrixWeightedQuadraticDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ListSizeConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

@Reference(authors="J. R. Smith, S. F. Chang", title="VisualSEEk: a fully automated content-based image query system", booktitle="Proc. 4th ACM Int. Conf. on Multimedia 1997", url="https://doi.org/10.1145/244130.244151", bibkey="DBLP:conf/mm/SmithC96")
public class HSBHistogramQuadraticDistanceFunction
extends MatrixWeightedQuadraticDistanceFunction {
    public HSBHistogramQuadraticDistanceFunction(int quanth, int quants, int quantb) {
        super(HSBHistogramQuadraticDistanceFunction.computeWeightMatrix(quanth, quants, quantb));
    }

    public static double[][] computeWeightMatrix(int quanth, int quants, int quantb) {
        int dim = quanth * quants * quantb;
        DoubleWrapper tmp = new DoubleWrapper();
        assert (dim > 0);
        double[][] m = new double[dim][dim];
        for (int x = 0; x < dim; ++x) {
            int hx = x / (quantb * quants);
            int sx = x / quantb % quants;
            int bx = x % quantb;
            for (int y = x; y < dim; ++y) {
                double val;
                int hy = y / (quantb * quants);
                int sy = y / quantb % quants;
                int by = y % quantb;
                double shx = FastMath.sinAndCos(((double)hx + 0.5) / (double)quanth * (Math.PI * 2), tmp);
                double chx = tmp.value;
                double shy = FastMath.sinAndCos(((double)hy + 0.5) / (double)quanth * (Math.PI * 2), tmp);
                double chy = tmp.value;
                double cos = chx * ((double)sx + 0.5) / (double)quants - chy * ((double)sy + 0.5) / (double)quants;
                double sin = shx * ((double)sx + 0.5) / (double)quants - shy * ((double)sy + 0.5) / (double)quants;
                double db = (double)(bx - by) / (double)quantb;
                double d = val = 1.0 - FastMath.sqrt((db * db + sin * sin + cos * cos) / 5.0);
                m[y][x] = d;
                m[x][y] = d;
            }
        }
        return m;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID BPP_ID = new OptionID("hsbhist.bpp", "The dimensionality of the histogram in hue, saturation and brightness.");
        int quanth = 0;
        int quants = 0;
        int quantb = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntListParameter param = (IntListParameter)((IntListParameter)new IntListParameter(BPP_ID).addConstraint((ParameterConstraint)new ListSizeConstraint(3))).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT_LIST);
            if (config.grab(param)) {
                int[] quant = (int[])param.getValue();
                assert (quant.length == 3);
                this.quanth = quant[0];
                this.quants = quant[1];
                this.quantb = quant[2];
            }
        }

        @Override
        protected HSBHistogramQuadraticDistanceFunction makeInstance() {
            return new HSBHistogramQuadraticDistanceFunction(this.quanth, this.quants, this.quantb);
        }
    }
}

