/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.colorhistogram;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M. J. Swain, D. H. Ballard", title="Color Indexing", booktitle="International Journal of Computer Vision, 7(1), 32, 1991", url="https://doi.org/10.1007/BF00130487", bibkey="DBLP:journals/ijcv/SwainB91")
public class HistogramIntersectionDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final HistogramIntersectionDistanceFunction STATIC = new HistogramIntersectionDistanceFunction();

    @Deprecated
    public HistogramIntersectionDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = HistogramIntersectionDistanceFunction.dimensionality(v1, v2);
        double agg = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < dim; ++i) {
            double val1 = v1.doubleValue(i);
            double val2 = v2.doubleValue(i);
            agg += Math.min(val1, val2);
            norm1 += val1;
            norm2 += val2;
        }
        return 1.0 - agg / Math.min(norm1, norm2);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim = HistogramIntersectionDistanceFunction.dimensionality(mbr1, mbr2);
        double agg = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < dim; ++i) {
            double min1 = mbr1.getMin(i);
            double max1 = mbr1.getMax(i);
            double min2 = mbr2.getMin(i);
            double max2 = mbr2.getMax(i);
            agg += Math.min(max1, max2);
            norm1 += Math.max(0.0, min1);
            norm2 += Math.max(0.0, min2);
        }
        double norm = Math.min(norm1, norm2);
        return norm > 0.0 && agg < norm ? 1.0 - agg / norm : 0.0;
    }

    public String toString() {
        return "HistogramIntersectionDistance";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HistogramIntersectionDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

