/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.colorhistogram;

import de.lmu.ifi.dbs.elki.distance.distancefunction.MatrixWeightedQuadraticDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. Hafner, H. S. Sawhney, W. Equits, M. Flickner, W. Niblack", title="Efficient Color Histogram Indexing for Quadratic Form Distance Functions", booktitle="IEEE Trans. on Pattern Analysis and Machine Intelligence 17(7)", url="https://doi.org/10.1109/34.391417", bibkey="DBLP:journals/pami/HafnerSEFN95")
public class RGBHistogramQuadraticDistanceFunction
extends MatrixWeightedQuadraticDistanceFunction {
    public RGBHistogramQuadraticDistanceFunction(int bpp) {
        super(RGBHistogramQuadraticDistanceFunction.computeWeightMatrix(bpp));
    }

    public static double[][] computeWeightMatrix(int bpp) {
        int dim = bpp * bpp * bpp;
        double[][] m = new double[dim][dim];
        double max = 3.0 * ((double)bpp - 1.0);
        for (int x = 0; x < dim; ++x) {
            int rx = x / bpp / bpp;
            int gx = x / bpp % bpp;
            int bx = x % bpp;
            for (int y = x; y < dim; ++y) {
                double val;
                int ry = y / bpp / bpp;
                int gy = y / bpp % bpp;
                int by = y % bpp;
                double dr = Math.abs(rx - ry);
                double dg = Math.abs(gx - gy);
                double db = Math.abs(bx - by);
                double d = val = 1.0 - (dr + dg + db) / max;
                m[y][x] = d;
                m[x][y] = d;
            }
        }
        return m;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID BPP_ID = new OptionID("rgbhist.bpp", "The dimensionality of the histogram in each color");
        int bpp = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter param = new IntParameter(BPP_ID);
            if (config.grab(param)) {
                this.bpp = (Integer)param.getValue();
            }
        }

        @Override
        protected RGBHistogramQuadraticDistanceFunction makeInstance() {
            return new RGBHistogramQuadraticDistanceFunction(this.bpp);
        }
    }
}

