/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.PearsonCorrelation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class SquaredPearsonCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final SquaredPearsonCorrelationDistanceFunction STATIC = new SquaredPearsonCorrelationDistanceFunction();

    @Deprecated
    public SquaredPearsonCorrelationDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        double pcc = PearsonCorrelation.coefficient(v1, v2);
        return 1.0 - pcc * pcc;
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    public String toString() {
        return "SquaredPearsonCorrelationDistance";
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SquaredPearsonCorrelationDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

