/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public class UncenteredCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final UncenteredCorrelationDistanceFunction STATIC = new UncenteredCorrelationDistanceFunction();

    @Deprecated
    public UncenteredCorrelationDistanceFunction() {
    }

    public static double uncenteredCorrelation(NumberVector x, NumberVector y) {
        int ydim;
        int xdim = x.getDimensionality();
        if (xdim != (ydim = y.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < xdim; ++i) {
            double xv = x.doubleValue(i);
            double yv = y.doubleValue(i);
            sumXX += xv * xv;
            sumYY += yv * yv;
            sumXY += xv * yv;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }

    public static double uncenteredCorrelation(double[] x, double[] y) {
        int xdim = x.length;
        int ydim = y.length;
        if (xdim != ydim) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < xdim; ++i) {
            double xv = x[i];
            double yv = y[i];
            sumXX += xv * xv;
            sumYY += yv * yv;
            sumXY += xv * yv;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        return 1.0 - UncenteredCorrelationDistanceFunction.uncenteredCorrelation(v1, v2);
    }

    public String toString() {
        return "UncenteredCorrelationDistance";
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UncenteredCorrelationDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

