/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.PearsonCorrelation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;

public class WeightedPearsonCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    private double[] weights;

    public WeightedPearsonCorrelationDistanceFunction(double[] weights) {
        this.weights = weights;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        return 1.0 - PearsonCorrelation.weightedCoefficient(v1, v2, this.weights);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this.weights, ((WeightedPearsonCorrelationDistanceFunction)obj).weights);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return "WeightedPearsonCorrelationDistanceFunction";
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter weightsP = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (config.grab(weightsP)) {
                this.weights = (double[])((double[])weightsP.getValue()).clone();
            }
        }

        @Override
        protected WeightedPearsonCorrelationDistanceFunction makeInstance() {
            return new WeightedPearsonCorrelationDistanceFunction(this.weights);
        }
    }
}

