/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.PearsonCorrelation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;

public class WeightedSquaredPearsonCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    private double[] weights;

    public WeightedSquaredPearsonCorrelationDistanceFunction(double[] weights) {
        this.weights = weights;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        double pcc = PearsonCorrelation.weightedCoefficient(v1, v2, this.weights);
        return 1.0 - pcc * pcc;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this.weights, ((WeightedSquaredPearsonCorrelationDistanceFunction)obj).weights);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter weightsP = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (config.grab(weightsP)) {
                this.weights = (double[])((double[])weightsP.getValue()).clone();
            }
        }

        @Override
        protected WeightedSquaredPearsonCorrelationDistanceFunction makeInstance() {
            return new WeightedSquaredPearsonCorrelationDistanceFunction(this.weights);
        }
    }
}

