/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceCacheWriter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.IOException;
import java.io.InputStream;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.parser.NumberDistanceParser", "de.lmu.ifi.dbs.elki.distance.distancefunction.external.NumberDistanceParser", "de.lmu.ifi.dbs.elki.parser.NumberDistanceParser"})
public class AsciiDistanceParser
implements DistanceParser {
    private static final Logging LOG = Logging.getLogger(AsciiDistanceParser.class);
    protected TokenizedReader reader;
    protected Tokenizer tokenizer;

    public AsciiDistanceParser(CSVReaderFormat format) {
        this.reader = format.makeReader();
        this.tokenizer = this.reader.getTokenizer();
    }

    @Override
    public void parse(InputStream in, DistanceCacheWriter cache) {
        this.reader.reset(in);
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("Parsing distance matrix", LOG) : null;
        try {
            while (this.reader.nextLineExceptComments()) {
                int id2;
                int id1;
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    id1 = this.tokenizer.getIntBase10();
                    this.tokenizer.advance();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ": id1 is not an integer!");
                }
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    id2 = this.tokenizer.getIntBase10();
                    this.tokenizer.advance();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ": id2 is not an integer!");
                }
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    cache.put(id1, id2, this.tokenizer.getDouble());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ":" + e.getMessage(), e);
                }
                this.tokenizer.advance();
                if (this.tokenizer.valid()) {
                    throw new IllegalArgumentException("More than three values in line " + this.reader.getLineNumber());
                }
                LOG.incrementProcessed(prog);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
        LOG.setCompleted(prog);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected CSVReaderFormat format;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.format = config.tryInstantiate(CSVReaderFormat.class);
        }

        @Override
        protected AsciiDistanceParser makeInstance() {
            return new AsciiDistanceParser(this.format);
        }
    }
}

