/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.OnDiskUpperTriangleMatrix;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.IOException;

public class DiskCacheBasedDoubleDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(DiskCacheBasedDoubleDistanceFunction.class);
    public static final int DOUBLE_CACHE_MAGIC = 50902811;
    private OnDiskUpperTriangleMatrix cache;

    public DiskCacheBasedDoubleDistanceFunction(OnDiskUpperTriangleMatrix cache) {
        this.cache = cache;
    }

    public DiskCacheBasedDoubleDistanceFunction(File matrixfile) throws IOException {
        this.cache = new OnDiskUpperTriangleMatrix(matrixfile, 50902811, 0, 8, false);
    }

    @Override
    public double distance(int i1, int i2) {
        if (i1 > i2) {
            return this.distance(i2, i1);
        }
        try {
            return this.cache.getRecordBuffer(i1, i2).getDouble();
        }
        catch (IOException e) {
            throw new RuntimeException("Read error when loading distance " + i1 + "," + i2 + " from cache file.", e);
        }
    }

    @Override
    public void checkRange(DBIDRange range) {
        if (this.cache.getMatrixSize() < range.size()) {
            LOG.warning("Distance matrix has size " + this.cache.getMatrixSize() + " but range has size: " + range.size());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiskCacheBasedDoubleDistanceFunction other = (DiskCacheBasedDoubleDistanceFunction)obj;
        return this.cache.equals(other.cache);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MATRIX_ID = new OptionID("distance.matrix", "The name of the file containing the distance matrix.");
        protected OnDiskUpperTriangleMatrix cache = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            FileParameter param = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(param)) {
                File matrixfile = (File)param.getValue();
                try {
                    this.cache = new OnDiskUpperTriangleMatrix(matrixfile, 50902811, 0, 8, false);
                }
                catch (IOException e) {
                    config.reportError(new WrongParameterValueException(param, matrixfile.toString(), e.getMessage(), e));
                }
            }
        }

        @Override
        protected DiskCacheBasedDoubleDistanceFunction makeInstance() {
            return new DiskCacheBasedDoubleDistanceFunction(this.cache);
        }
    }
}

