/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DiskCacheBasedDoubleDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.OnDiskUpperTriangleMatrix;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.IOException;

public class DiskCacheBasedFloatDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(DiskCacheBasedFloatDistanceFunction.class);
    public static final int FLOAT_CACHE_MAGIC = 23423411;
    private OnDiskUpperTriangleMatrix cache;

    public DiskCacheBasedFloatDistanceFunction(OnDiskUpperTriangleMatrix cache) {
        this.cache = cache;
    }

    public DiskCacheBasedFloatDistanceFunction(File matrixfile) throws IOException {
        this.cache = new OnDiskUpperTriangleMatrix(matrixfile, 23423411, 0, 4, false);
    }

    @Override
    public double distance(int i1, int i2) {
        if (i1 > i2) {
            return this.distance(i2, i1);
        }
        try {
            return this.cache.getRecordBuffer(i1, i2).getFloat();
        }
        catch (IOException e) {
            throw new RuntimeException("Read error when loading distance " + i1 + "," + i2 + " from cache file.", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskCacheBasedFloatDistanceFunction other = (DiskCacheBasedFloatDistanceFunction)obj;
        return this.cache.equals(other.cache);
    }

    @Override
    public void checkRange(DBIDRange range) {
        if (this.cache.getMatrixSize() < range.size()) {
            LOG.warning("Distance matrix has size " + this.cache.getMatrixSize() + " but range has size: " + range.size());
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MATRIX_ID = DiskCacheBasedDoubleDistanceFunction.Parameterizer.MATRIX_ID;
        protected OnDiskUpperTriangleMatrix cache = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            FileParameter param = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(param)) {
                File matrixfile = (File)param.getValue();
                try {
                    this.cache = new OnDiskUpperTriangleMatrix(matrixfile, 23423411, 0, 4, false);
                }
                catch (IOException e) {
                    config.reportError(new WrongParameterValueException(param, matrixfile.toString(), e.getMessage(), e));
                }
            }
        }

        @Override
        protected DiskCacheBasedFloatDistanceFunction makeInstance() {
            return new DiskCacheBasedFloatDistanceFunction(this.cache);
        }
    }
}

