/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.AsciiDistanceParser;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceCacheWriter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.external.FileBasedDoubleDistanceFunction"})
public class FileBasedSparseDoubleDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(FileBasedSparseDoubleDistanceFunction.class);
    private Long2DoubleOpenHashMap cache;
    private DistanceParser parser;
    private File matrixfile;
    private int min;
    private int max;
    protected double defaultDistance = Double.POSITIVE_INFINITY;

    public FileBasedSparseDoubleDistanceFunction(DistanceParser parser, File matrixfile, double defaultDistance) {
        this.parser = parser;
        this.matrixfile = matrixfile;
        this.defaultDistance = defaultDistance;
    }

    @Override
    public <O extends DBID> DistanceQuery<O> instantiate(Relation<O> relation) {
        if (this.cache == null) {
            int size = relation.size();
            try {
                this.loadCache(size, new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(this.matrixfile))));
            }
            catch (IOException e) {
                throw new AbortException("Could not load external distance file: " + this.matrixfile.toString(), e);
            }
        }
        return super.instantiate(relation);
    }

    @Override
    public double distance(int i1, int i2) {
        return i1 == i2 ? 0.0 : this.cache.get(FileBasedSparseDoubleDistanceFunction.makeKey(i1 + this.min, i2 + this.min));
    }

    protected void loadCache(int size, InputStream in) throws IOException {
        this.cache = new Long2DoubleOpenHashMap(size * 20);
        this.cache.defaultReturnValue(Double.POSITIVE_INFINITY);
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.parser.parse(in, new DistanceCacheWriter(){

            @Override
            public void put(int id1, int id2, double distance) {
                if (id1 < id2) {
                    FileBasedSparseDoubleDistanceFunction.this.min = id1 < FileBasedSparseDoubleDistanceFunction.this.min ? id1 : FileBasedSparseDoubleDistanceFunction.this.min;
                    FileBasedSparseDoubleDistanceFunction.this.max = id2 > FileBasedSparseDoubleDistanceFunction.this.max ? id2 : FileBasedSparseDoubleDistanceFunction.this.max;
                } else {
                    FileBasedSparseDoubleDistanceFunction.this.min = id2 < FileBasedSparseDoubleDistanceFunction.this.min ? id2 : FileBasedSparseDoubleDistanceFunction.this.min;
                    FileBasedSparseDoubleDistanceFunction.this.max = id1 > FileBasedSparseDoubleDistanceFunction.this.max ? id1 : FileBasedSparseDoubleDistanceFunction.this.max;
                }
                FileBasedSparseDoubleDistanceFunction.this.cache.put(FileBasedSparseDoubleDistanceFunction.makeKey(id1, id2), distance);
            }
        });
        if (this.min != 0 && LOG.isVerbose()) {
            LOG.verbose("Distance matrix is supposed to be 0-indexed. Choosing offset " + this.min + " to compensate.");
        }
        if (this.max + 1 - this.min != size) {
            LOG.warning("ID range is not consistent with relation size.");
        }
    }

    protected static final long makeKey(int i1, int i2) {
        return i1 < i2 ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
    }

    @Override
    public void checkRange(DBIDRange range) {
        int size = this.max + 1 - this.min;
        if (size < range.size()) {
            LOG.warning("Distance matrix has size " + size + " but range has size: " + range.size());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileBasedSparseDoubleDistanceFunction other = (FileBasedSparseDoubleDistanceFunction)obj;
        return this.cache.equals(other.cache);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MATRIX_ID = new OptionID("distance.matrix", "The name of the file containing the distance matrix.");
        public static final OptionID PARSER_ID = new OptionID("distance.parser", "Parser used to load the distance matrix.");
        public static final OptionID DEFAULTDIST_ID = new OptionID("distance.default", "Default distance to use for undefined values.");
        protected File matrixfile = null;
        protected DistanceParser parser = null;
        protected double defaultDistance = Double.POSITIVE_INFINITY;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter distanceP;
            ObjectParameter parserP;
            super.makeOptions(config);
            FileParameter matrixfileP = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(matrixfileP)) {
                this.matrixfile = (File)matrixfileP.getValue();
            }
            if (config.grab(parserP = new ObjectParameter(PARSER_ID, (Class<?>)DistanceParser.class, AsciiDistanceParser.class))) {
                this.parser = (DistanceParser)parserP.instantiateClass(config);
            }
            if (config.grab(distanceP = new DoubleParameter(DEFAULTDIST_ID, Double.POSITIVE_INFINITY))) {
                this.defaultDistance = distanceP.doubleValue();
            }
        }

        @Override
        protected FileBasedSparseDoubleDistanceFunction makeInstance() {
            return new FileBasedSparseDoubleDistanceFunction(this.parser, this.matrixfile, this.defaultDistance);
        }
    }
}

