/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.AsciiDistanceParser;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceCacheWriter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceParser;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.FileBasedSparseDoubleDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.external.FileBasedFloatDistanceFunction"})
public class FileBasedSparseFloatDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(FileBasedSparseFloatDistanceFunction.class);
    private Long2FloatOpenHashMap cache;
    private DistanceParser parser;
    private File matrixfile;
    private int min;
    private int max;
    protected float defaultDistance = Float.POSITIVE_INFINITY;

    public FileBasedSparseFloatDistanceFunction(DistanceParser parser, File matrixfile, float defaultDistance) {
        this.parser = parser;
        this.matrixfile = matrixfile;
        this.defaultDistance = defaultDistance;
    }

    @Override
    public <O extends DBID> DistanceQuery<O> instantiate(Relation<O> relation) {
        if (this.cache == null) {
            try {
                this.loadCache(relation.size(), new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(this.matrixfile))));
            }
            catch (IOException e) {
                throw new AbortException("Could not load external distance file: " + this.matrixfile.toString(), e);
            }
        }
        return super.instantiate(relation);
    }

    @Override
    public double distance(int i1, int i2) {
        return i1 == i2 ? 0.0 : (double)this.cache.get(FileBasedSparseFloatDistanceFunction.makeKey(i1 + this.min, i2 + this.min));
    }

    protected void loadCache(int size, InputStream in) throws IOException {
        this.cache = new Long2FloatOpenHashMap(size * 20);
        this.cache.defaultReturnValue(Float.POSITIVE_INFINITY);
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.parser.parse(in, new DistanceCacheWriter(){

            @Override
            public void put(int id1, int id2, double distance) {
                if (id1 < id2) {
                    FileBasedSparseFloatDistanceFunction.this.min = id1 < FileBasedSparseFloatDistanceFunction.this.min ? id1 : FileBasedSparseFloatDistanceFunction.this.min;
                    FileBasedSparseFloatDistanceFunction.this.max = id2 > FileBasedSparseFloatDistanceFunction.this.max ? id2 : FileBasedSparseFloatDistanceFunction.this.max;
                } else {
                    FileBasedSparseFloatDistanceFunction.this.min = id2 < FileBasedSparseFloatDistanceFunction.this.min ? id2 : FileBasedSparseFloatDistanceFunction.this.min;
                    FileBasedSparseFloatDistanceFunction.this.max = id1 > FileBasedSparseFloatDistanceFunction.this.max ? id1 : FileBasedSparseFloatDistanceFunction.this.max;
                }
                FileBasedSparseFloatDistanceFunction.this.cache.put(FileBasedSparseFloatDistanceFunction.makeKey(id1, id2), (float)distance);
            }
        });
        if (this.min != 0) {
            LOG.verbose("Distance matrix is supposed to be 0-indexed. Choosing offset " + this.min + " to compensate.");
        }
        if (this.max + 1 - this.min != size) {
            LOG.warning("ID range is not consistent with relation size.");
        }
    }

    protected static final long makeKey(int i1, int i2) {
        return i1 < i2 ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
    }

    @Override
    public void checkRange(DBIDRange range) {
        int size = this.max + 1 - this.min;
        if (size < range.size()) {
            LOG.warning("Distance matrix has size " + size + " but range has size: " + range.size());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileBasedSparseFloatDistanceFunction other = (FileBasedSparseFloatDistanceFunction)obj;
        return this.cache.equals(other.cache);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MATRIX_ID = FileBasedSparseDoubleDistanceFunction.Parameterizer.MATRIX_ID;
        public static final OptionID PARSER_ID = FileBasedSparseDoubleDistanceFunction.Parameterizer.PARSER_ID;
        public static final OptionID DEFAULTDIST_ID = FileBasedSparseDoubleDistanceFunction.Parameterizer.DEFAULTDIST_ID;
        protected File matrixfile = null;
        protected DistanceParser parser = null;
        protected float defaultDistance = Float.POSITIVE_INFINITY;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter distanceP;
            ObjectParameter PARSER_PARAM;
            super.makeOptions(config);
            FileParameter MATRIX_PARAM = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(MATRIX_PARAM)) {
                this.matrixfile = (File)MATRIX_PARAM.getValue();
            }
            if (config.grab(PARSER_PARAM = new ObjectParameter(PARSER_ID, (Class<?>)DistanceParser.class, AsciiDistanceParser.class))) {
                this.parser = (DistanceParser)PARSER_PARAM.instantiateClass(config);
            }
            if (config.grab(distanceP = new DoubleParameter(DEFAULTDIST_ID, Double.POSITIVE_INFINITY))) {
                this.defaultDistance = (float)distanceP.doubleValue();
            }
        }

        @Override
        protected FileBasedSparseFloatDistanceFunction makeInstance() {
            return new FileBasedSparseFloatDistanceFunction(this.parser, this.matrixfile, this.defaultDistance);
        }
    }
}

