/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.geo;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
public class DimensionSelectingLatLngDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    final int dimlat;
    final int dimlng;
    final EarthModel model;

    public DimensionSelectingLatLngDistanceFunction(int dimlat, int dimlng, EarthModel model) {
        this.dimlat = dimlat;
        this.dimlng = dimlng;
        this.model = model;
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        return this.model.distanceDeg(o1.doubleValue(this.dimlat), o1.doubleValue(this.dimlng), o2.doubleValue(this.dimlat), o2.doubleValue(this.dimlng));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 instanceof NumberVector) {
            if (mbr2 instanceof NumberVector) {
                return this.distance((NumberVector)mbr1, (NumberVector)mbr2);
            }
            NumberVector o1 = (NumberVector)mbr1;
            return this.model.minDistDeg(o1.doubleValue(this.dimlat), o1.doubleValue(this.dimlng), mbr2.getMin(this.dimlat), mbr2.getMin(this.dimlng), mbr2.getMax(this.dimlat), mbr2.getMax(this.dimlng));
        }
        if (mbr2 instanceof NumberVector) {
            NumberVector o2 = (NumberVector)mbr2;
            return this.model.minDistDeg(o2.doubleValue(this.dimlat), o2.doubleValue(this.dimlng), mbr1.getMin(this.dimlat), mbr1.getMin(this.dimlng), mbr1.getMax(this.dimlat), mbr1.getMax(this.dimlng));
        }
        throw new NotImplementedException("This distance function cannot - yet - be used with this algorithm, as the lower bound rectangle to rectangle distances have not yet been formalized for geodetic data.");
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, Math.max(this.dimlat, this.dimlng), Integer.MAX_VALUE);
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimlat;
        result = 31 * result + this.dimlng;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof DimensionSelectingLatLngDistanceFunction && this.model.equals(((DimensionSelectingLatLngDistanceFunction)obj).model);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID LATDIM_ID = new OptionID("distance.latitudedim", "The dimension containing the latitude.");
        public static final OptionID LNGDIM_ID = new OptionID("distance.longitudedim", "The dimension containing the longitude.");
        int dimlat;
        int dimlng;
        EarthModel model;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter modelP;
            IntParameter dimlngP;
            super.makeOptions(config);
            IntParameter dimlatP = (IntParameter)new IntParameter(LATDIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(dimlatP)) {
                this.dimlat = (Integer)dimlatP.getValue();
            }
            if (config.grab(dimlngP = (IntParameter)new IntParameter(LNGDIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT))) {
                this.dimlng = (Integer)dimlngP.getValue();
            }
            if (this.dimlat == this.dimlng) {
                config.reportError(new WrongParameterValueException(dimlatP, "and", dimlngP, "should be different columns."));
            }
            if (config.grab(modelP = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class))) {
                this.model = (EarthModel)modelP.instantiateClass(config);
            }
        }

        @Override
        protected DimensionSelectingLatLngDistanceFunction makeInstance() {
            return new DimensionSelectingLatLngDistanceFunction(this.dimlat, this.dimlng, this.model);
        }
    }
}

