/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.geo;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
public class LngLatDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    private EarthModel model;

    public LngLatDistanceFunction(EarthModel model) {
        this.model = model;
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        return this.model.distanceDeg(o1.doubleValue(1), o1.doubleValue(0), o2.doubleValue(1), o2.doubleValue(0));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 instanceof NumberVector) {
            if (mbr2 instanceof NumberVector) {
                return this.distance((NumberVector)mbr1, (NumberVector)mbr2);
            }
            NumberVector o1 = (NumberVector)mbr1;
            return this.model.minDistDeg(o1.doubleValue(1), o1.doubleValue(0), mbr2.getMin(1), mbr2.getMin(0), mbr2.getMax(1), mbr2.getMax(0));
        }
        if (mbr2 instanceof NumberVector) {
            NumberVector o2 = (NumberVector)mbr2;
            return this.model.minDistDeg(o2.doubleValue(1), o2.doubleValue(0), mbr1.getMin(1), mbr1.getMin(0), mbr1.getMax(1), mbr1.getMax(0));
        }
        throw new NotImplementedException("This distance function cannot - yet - be used with this algorithm, as the lower bound rectangle to rectangle distances have not yet been formalized for geodetic data.");
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.FIELD_2D;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public int hashCode() {
        return this.model.hashCode() + this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof LngLatDistanceFunction && this.model.equals(((LngLatDistanceFunction)obj).model);
    }

    public String toString() {
        return "LngLatDistanceFunction [model=" + this.model + "]";
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        EarthModel model;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter modelP = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (config.grab(modelP)) {
                this.model = (EarthModel)modelP.instantiateClass(config);
            }
        }

        @Override
        protected LngLatDistanceFunction makeInstance() {
            return new LngLatDistanceFunction(this.model);
        }
    }
}

