/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.histogram;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="L. N. Vaserstein", title="Markov processes over denumerable products of spaces describing large systems of automata", booktitle="Problemy Peredachi Informatsii 5.3 / Problems of Information Transmission, 5:3", url="http://mi.mathnet.ru/eng/ppi1811", bibkey="journals/misc/Vaserstein69")
public class HistogramMatchDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final HistogramMatchDistanceFunction STATIC = new HistogramMatchDistanceFunction();

    @Deprecated
    public HistogramMatchDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int i;
        int dim = HistogramMatchDistanceFunction.dimensionality(v1, v2);
        double xs = 0.0;
        double ys = 0.0;
        double agg = 0.0;
        for (i = 0; i < dim; ++i) {
            xs += v1.doubleValue(i);
        }
        for (i = 0; i < dim; ++i) {
            ys += v2.doubleValue(i);
        }
        double fx = xs > 0.0 ? 1.0 / xs : 1.0;
        double fy = ys > 0.0 ? 1.0 / ys : 1.0;
        for (int i2 = 0; i2 < dim; ++i2) {
            agg += Math.abs(v1.doubleValue(i2) * fx - v2.doubleValue(i2) * fy);
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int i;
        int dim = HistogramMatchDistanceFunction.dimensionality(mbr1, mbr2);
        double min1 = 0.0;
        double max1 = 0.0;
        double min2 = 0.0;
        double max2 = 0.0;
        double agg = 0.0;
        for (i = 0; i < dim; ++i) {
            min1 += mbr1.getMin(i);
        }
        for (i = 0; i < dim; ++i) {
            max1 += mbr1.getMax(i);
        }
        for (i = 0; i < dim; ++i) {
            min2 += mbr2.getMin(i);
        }
        for (i = 0; i < dim; ++i) {
            max2 += mbr2.getMax(i);
        }
        double fmi1 = min1 > 0.0 ? 1.0 / min1 : 1.0;
        double fma1 = max1 > 0.0 ? 1.0 / max1 : 0.0;
        double fmi2 = min2 > 0.0 ? 1.0 / min2 : 1.0;
        double fma2 = max2 > 0.0 ? 1.0 / max2 : 0.0;
        for (int i2 = 0; i2 < dim; ++i2) {
            double d1 = mbr2.getMin(i2) * fma2 - mbr1.getMax(i2) * fmi1;
            agg += d1 > 0.0 ? d1 : Math.max(mbr1.getMin(i2) * fma1 - mbr2.getMax(i2) * fmi2, 0.0);
        }
        return agg;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public String toString() {
        return "HistogramMatchDistanceFunction";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HistogramMatchDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

