/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPIntegerNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Priority(value=300)
@Alias(value={"euclidean", "euclid", "l2", "de.lmu.ifi.dbs.elki.distance.distancefunction.EuclideanDistanceFunction"})
public class EuclideanDistanceFunction
extends LPIntegerNormDistanceFunction {
    public static final EuclideanDistanceFunction STATIC = new EuclideanDistanceFunction();

    @Deprecated
    public EuclideanDistanceFunction() {
        super(2);
    }

    private double preDistance(NumberVector v1, NumberVector v2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = v1.doubleValue(d) - v2.doubleValue(d);
            agg += delta * delta;
        }
        return agg;
    }

    private double preDistanceVM(NumberVector v, SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double value = v.doubleValue(d);
            double delta = mbr.getMin(d) - value;
            double d2 = delta = delta >= 0.0 ? delta : value - mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta;
        }
        return agg;
    }

    private double preDistanceMBR(SpatialComparable mbr1, SpatialComparable mbr2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr2.getMin(d) - mbr1.getMax(d);
            double d2 = delta = delta >= 0.0 ? delta : mbr1.getMin(d) - mbr2.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta;
        }
        return agg;
    }

    private double preNorm(NumberVector v, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v.doubleValue(d);
            agg += xd * xd;
        }
        return agg;
    }

    private double preNormMBR(SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr.getMin(d);
            double d2 = delta = delta >= 0.0 ? delta : -mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta;
        }
        return agg;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = this.preDistance(v1, v2, 0, mindim);
        if (dim1 > mindim) {
            agg += this.preNorm(v1, mindim, dim1);
        } else if (dim2 > mindim) {
            agg += this.preNorm(v2, mindim, dim2);
        }
        return FastMath.sqrt(agg);
    }

    @Override
    public double norm(NumberVector v) {
        return FastMath.sqrt(this.preNorm(v, 0, v.getDimensionality()));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double agg;
        NumberVector v2;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        NumberVector v1 = mbr1 instanceof NumberVector ? (NumberVector)mbr1 : null;
        NumberVector numberVector = v2 = mbr2 instanceof NumberVector ? (NumberVector)mbr2 : null;
        double d = v1 != null ? (v2 != null ? this.preDistance(v1, v2, 0, mindim) : this.preDistanceVM(v1, mbr2, 0, mindim)) : (agg = v2 != null ? this.preDistanceVM(v2, mbr1, 0, mindim) : this.preDistanceMBR(mbr1, mbr2, 0, mindim));
        if (dim1 > mindim) {
            agg += v1 != null ? this.preNorm(v1, mindim, dim1) : this.preNormMBR(mbr1, mindim, dim1);
        }
        if (dim2 > mindim) {
            agg += v2 != null ? this.preNorm(v2, mindim, dim2) : this.preNormMBR(mbr2, mindim, dim2);
        }
        return FastMath.sqrt(agg);
    }

    public double maxDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double delta;
        double d2;
        double d1;
        int d;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            d1 = mbr1.getMax(d) - mbr2.getMin(d);
            delta = d1 > (d2 = mbr2.getMax(d) - mbr1.getMin(d)) ? d1 : d2;
            agg += delta * delta;
        }
        for (d = mindim; d < dim1; ++d) {
            d1 = Math.abs(mbr1.getMin(d));
            delta = d1 > (d2 = Math.abs(mbr1.getMax(d))) ? d1 : d2;
            agg += delta * delta;
        }
        for (d = mindim; d < dim2; ++d) {
            d1 = Math.abs(mbr2.getMin(d));
            delta = d1 > (d2 = Math.abs(mbr2.getMax(d))) ? d1 : d2;
            agg += delta * delta;
        }
        return FastMath.sqrt(agg);
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public String toString() {
        return "EuclideanDistance";
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected EuclideanDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

