/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPIntegerNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.ManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.MaximumDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Priority(value=200)
@Alias(value={"lp", "minkowski", "p", "de.lmu.ifi.dbs.elki.distance.distancefunction.LPNormDistanceFunction"})
public class LPNormDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NumberVectorDistanceFunction<NumberVector>,
Norm<NumberVector> {
    protected double p;
    protected double invp;

    public LPNormDistanceFunction(double p) {
        this.p = p;
        this.invp = 1.0 / p;
    }

    private double preDistance(NumberVector v1, NumberVector v2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double yd;
            double xd = v1.doubleValue(d);
            double delta = xd >= (yd = v2.doubleValue(d)) ? xd - yd : yd - xd;
            agg += FastMath.pow(delta, this.p);
        }
        return agg;
    }

    private double preDistanceVM(NumberVector v, SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double value = v.doubleValue(d);
            double min = mbr.getMin(d);
            double delta = min - value;
            double d2 = delta = delta >= 0.0 ? delta : value - mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += FastMath.pow(delta, this.p);
        }
        return agg;
    }

    private double preDistanceMBR(SpatialComparable mbr1, SpatialComparable mbr2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr2.getMin(d) - mbr1.getMax(d);
            double d2 = delta = delta >= 0.0 ? delta : mbr1.getMin(d) - mbr2.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += FastMath.pow(delta, this.p);
        }
        return agg;
    }

    private double preNorm(NumberVector v, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v.doubleValue(d);
            double delta = xd >= 0.0 ? xd : -xd;
            agg += FastMath.pow(delta, this.p);
        }
        return agg;
    }

    private double preNormMBR(SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr.getMin(d);
            double d2 = delta = delta >= 0.0 ? delta : -mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += FastMath.pow(delta, this.p);
        }
        return agg;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = this.preDistance(v1, v2, 0, mindim);
        if (dim1 > mindim) {
            agg += this.preNorm(v1, mindim, dim1);
        } else if (dim2 > mindim) {
            agg += this.preNorm(v2, mindim, dim2);
        }
        return FastMath.pow(agg, this.invp);
    }

    @Override
    public double norm(NumberVector v) {
        return FastMath.pow(this.preNorm(v, 0, v.getDimensionality()), this.invp);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double agg;
        NumberVector v2;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        NumberVector v1 = mbr1 instanceof NumberVector ? (NumberVector)mbr1 : null;
        NumberVector numberVector = v2 = mbr2 instanceof NumberVector ? (NumberVector)mbr2 : null;
        double d = v1 != null ? (v2 != null ? this.preDistance(v1, v2, 0, mindim) : this.preDistanceVM(v1, mbr2, 0, mindim)) : (agg = v2 != null ? this.preDistanceVM(v2, mbr1, 0, mindim) : this.preDistanceMBR(mbr1, mbr2, 0, mindim));
        if (dim1 > mindim) {
            agg += v1 != null ? this.preNorm(v1, mindim, dim1) : this.preNormMBR(mbr1, mindim, dim1);
        }
        if (dim2 > mindim) {
            agg += v2 != null ? this.preNorm(v2, mindim, dim2) : this.preNormMBR(mbr2, mindim, dim2);
        }
        return FastMath.pow(agg, this.invp);
    }

    @Override
    public boolean isMetric() {
        return this.p >= 1.0;
    }

    public String toString() {
        return "L_" + this.p + "Norm";
    }

    public double getP() {
        return this.p;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass()) && this.p == ((LPNormDistanceFunction)obj).p;
    }

    public int hashCode() {
        return Double.hashCode(this.p) * 31 + this.getClass().hashCode();
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID P_ID = new OptionID("lpnorm.p", "Degree p of the L_p-Norm (positive number)");
        protected double p;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter paramP = (DoubleParameter)new DoubleParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(paramP)) {
                this.p = (Double)paramP.getValue();
            }
        }

        @Override
        protected LPNormDistanceFunction makeInstance() {
            return this.p == (double)((int)this.p) ? (this.p == 1.0 ? ManhattanDistanceFunction.STATIC : (this.p == 2.0 ? EuclideanDistanceFunction.STATIC : new LPIntegerNormDistanceFunction((int)this.p))) : (this.p == Double.POSITIVE_INFINITY ? MaximumDistanceFunction.STATIC : new LPNormDistanceFunction(this.p));
        }
    }
}

