/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"minimum", "min", "de.lmu.ifi.dbs.elki.distance.distancefunction.MinimumDistanceFunction"})
public class MinimumDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
Norm<NumberVector> {
    public static final MinimumDistanceFunction STATIC = new MinimumDistanceFunction();

    @Deprecated
    public MinimumDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = MinimumDistanceFunction.dimensionality(v1, v2);
        double agg = Double.POSITIVE_INFINITY;
        for (int d = 0; d < dim; ++d) {
            double yd;
            double xd = v1.doubleValue(d);
            double val = xd >= (yd = v2.doubleValue(d)) ? xd - yd : yd - xd;
            agg = val < agg ? val : agg;
        }
        return agg;
    }

    @Override
    public double norm(NumberVector v) {
        int dim = v.getDimensionality();
        double agg = Double.POSITIVE_INFINITY;
        for (int d = 0; d < dim; ++d) {
            double xd = v.doubleValue(d);
            double val = xd >= 0.0 ? xd : -xd;
            agg = val < agg ? val : agg;
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 instanceof NumberVector && mbr2 instanceof NumberVector) {
            return this.distance((NumberVector)mbr1, (NumberVector)mbr2);
        }
        int dim = MinimumDistanceFunction.dimensionality(mbr1, mbr2);
        double agg = Double.POSITIVE_INFINITY;
        for (int d = 0; d < dim; ++d) {
            double diff = mbr2.getMin(d) - mbr1.getMax(d);
            if (diff <= 0.0 && (diff = mbr1.getMin(d) - mbr2.getMax(d)) <= 0.0) {
                return 0.0;
            }
            agg = diff > agg ? agg : diff;
        }
        return agg;
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    public String toString() {
        return "MinimumDistance";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MinimumDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

