/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseMaximumDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.SparseLPNormDistanceFunction"})
public class SparseLPNormDistanceFunction
implements PrimitiveDistanceFunction<SparseNumberVector>,
Norm<SparseNumberVector> {
    private double p;
    private double invp;

    public SparseLPNormDistanceFunction(double p) {
        this.p = p;
        this.invp = 1.0 / p;
    }

    @Override
    public double distance(SparseNumberVector v1, SparseNumberVector v2) {
        double accu = 0.0;
        int i1 = v1.iter();
        int i2 = v2.iter();
        while (v1.iterValid(i1) && v2.iterValid(i2)) {
            double val;
            int d2;
            int d1 = v1.iterDim(i1);
            if (d1 < (d2 = v2.iterDim(i2))) {
                val = Math.abs(v1.iterDoubleValue(i1));
                accu += FastMath.pow(val, this.p);
                i1 = v1.iterAdvance(i1);
                continue;
            }
            if (d2 < d1) {
                val = Math.abs(v2.iterDoubleValue(i2));
                accu += FastMath.pow(val, this.p);
                i2 = v2.iterAdvance(i2);
                continue;
            }
            val = Math.abs(v1.iterDoubleValue(i1) - v2.iterDoubleValue(i2));
            accu += FastMath.pow(val, this.p);
            i1 = v1.iterAdvance(i1);
            i2 = v2.iterAdvance(i2);
        }
        while (v1.iterValid(i1)) {
            double val = Math.abs(v1.iterDoubleValue(i1));
            accu += FastMath.pow(val, this.p);
            i1 = v1.iterAdvance(i1);
        }
        while (v2.iterValid(i2)) {
            double val = Math.abs(v2.iterDoubleValue(i2));
            accu += FastMath.pow(val, this.p);
            i2 = v2.iterAdvance(i2);
        }
        return FastMath.pow(accu, this.invp);
    }

    @Override
    public double norm(SparseNumberVector v1) {
        double accu = 0.0;
        int it = v1.iter();
        while (v1.iterValid(it)) {
            double val = Math.abs(v1.iterDoubleValue(it));
            accu += FastMath.pow(val, this.p);
            it = v1.iterAdvance(it);
        }
        return FastMath.pow(accu, this.invp);
    }

    @Override
    public SimpleTypeInformation<? super SparseNumberVector> getInputTypeRestriction() {
        return SparseNumberVector.VARIABLE_LENGTH;
    }

    @Override
    public boolean isMetric() {
        return this.p >= 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        double p = 2.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter pP = (DoubleParameter)new DoubleParameter(LPNormDistanceFunction.Parameterizer.P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(pP)) {
                this.p = (Double)pP.getValue();
            }
        }

        @Override
        protected SparseLPNormDistanceFunction makeInstance() {
            if (this.p == 2.0) {
                return SparseEuclideanDistanceFunction.STATIC;
            }
            if (this.p == 1.0) {
                return SparseManhattanDistanceFunction.STATIC;
            }
            if (this.p == Double.POSITIVE_INFINITY) {
                return SparseMaximumDistanceFunction.STATIC;
            }
            return new SparseLPNormDistanceFunction(this.p);
        }
    }
}

