/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.SparseManhattanDistanceFunction"})
public class SparseManhattanDistanceFunction
extends SparseLPNormDistanceFunction {
    public static final SparseManhattanDistanceFunction STATIC = new SparseManhattanDistanceFunction();

    @Deprecated
    public SparseManhattanDistanceFunction() {
        super(1.0);
    }

    @Override
    public double distance(SparseNumberVector v1, SparseNumberVector v2) {
        double accu = 0.0;
        int i1 = v1.iter();
        int i2 = v2.iter();
        while (v1.iterValid(i1) && v2.iterValid(i2)) {
            double val;
            int d2;
            int d1 = v1.iterDim(i1);
            if (d1 < (d2 = v2.iterDim(i2))) {
                val = Math.abs(v1.iterDoubleValue(i1));
                accu += val;
                i1 = v1.iterAdvance(i1);
                continue;
            }
            if (d2 < d1) {
                val = Math.abs(v2.iterDoubleValue(i2));
                accu += val;
                i2 = v2.iterAdvance(i2);
                continue;
            }
            val = Math.abs(v1.iterDoubleValue(i1) - v2.iterDoubleValue(i2));
            accu += val;
            i1 = v1.iterAdvance(i1);
            i2 = v2.iterAdvance(i2);
        }
        while (v1.iterValid(i1)) {
            double val = Math.abs(v1.iterDoubleValue(i1));
            accu += val;
            i1 = v1.iterAdvance(i1);
        }
        while (v2.iterValid(i2)) {
            double val = Math.abs(v2.iterDoubleValue(i2));
            accu += val;
            i2 = v2.iterAdvance(i2);
        }
        return accu;
    }

    @Override
    public double norm(SparseNumberVector v1) {
        double accu = 0.0;
        int it = v1.iter();
        while (v1.iterValid(it)) {
            double val = Math.abs(v1.iterDoubleValue(it));
            accu += val;
            it = v1.iterAdvance(it);
        }
        return accu;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SparseManhattanDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

