/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class SparseSquaredEuclideanDistanceFunction
implements PrimitiveDistanceFunction<SparseNumberVector>,
Norm<SparseNumberVector> {
    public static final SparseSquaredEuclideanDistanceFunction STATIC = new SparseSquaredEuclideanDistanceFunction();

    @Deprecated
    public SparseSquaredEuclideanDistanceFunction() {
    }

    @Override
    public double distance(SparseNumberVector v1, SparseNumberVector v2) {
        double accu = 0.0;
        int i1 = v1.iter();
        int i2 = v2.iter();
        while (v1.iterValid(i1) && v2.iterValid(i2)) {
            double val;
            int d2;
            int d1 = v1.iterDim(i1);
            if (d1 < (d2 = v2.iterDim(i2))) {
                val = v1.iterDoubleValue(i1);
                accu += val * val;
                i1 = v1.iterAdvance(i1);
                continue;
            }
            if (d2 < d1) {
                val = v2.iterDoubleValue(i2);
                accu += val * val;
                i2 = v2.iterAdvance(i2);
                continue;
            }
            val = v1.iterDoubleValue(i1) - v2.iterDoubleValue(i2);
            accu += val * val;
            i1 = v1.iterAdvance(i1);
            i2 = v2.iterAdvance(i2);
        }
        while (v1.iterValid(i1)) {
            double val = v1.iterDoubleValue(i1);
            accu += val * val;
            i1 = v1.iterAdvance(i1);
        }
        while (v2.iterValid(i2)) {
            double val = v2.iterDoubleValue(i2);
            accu += val * val;
            i2 = v2.iterAdvance(i2);
        }
        return accu;
    }

    @Override
    public double norm(SparseNumberVector v1) {
        double accu = 0.0;
        int it = v1.iter();
        while (v1.iterValid(it)) {
            double val = v1.iterDoubleValue(it);
            accu += val * val;
            it = v1.iterAdvance(it);
        }
        return accu;
    }

    @Override
    public SimpleTypeInformation<? super SparseNumberVector> getInputTypeRestriction() {
        return SparseNumberVector.VARIABLE_LENGTH;
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SparseSquaredEuclideanDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

