/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"squaredeuclidean", "de.lmu.ifi.dbs.elki.distance.distancefunction.SquaredEuclideanDistanceFunction"})
public class SquaredEuclideanDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
Norm<NumberVector> {
    public static final SquaredEuclideanDistanceFunction STATIC = new SquaredEuclideanDistanceFunction();

    @Deprecated
    public SquaredEuclideanDistanceFunction() {
    }

    private double preDistance(double[] v1, double[] v2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = v1[d] - v2[d];
            agg += delta * delta;
        }
        return agg;
    }

    private double preDistance(NumberVector v1, NumberVector v2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = v1.doubleValue(d) - v2.doubleValue(d);
            agg += delta * delta;
        }
        return agg;
    }

    private double preDistanceVM(NumberVector v, SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double value = v.doubleValue(d);
            double delta = mbr.getMin(d) - value;
            double d2 = delta = delta >= 0.0 ? delta : value - mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta;
        }
        return agg;
    }

    private double preDistanceMBR(SpatialComparable mbr1, SpatialComparable mbr2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr2.getMin(d) - mbr1.getMax(d);
            double d2 = delta = delta >= 0.0 ? delta : mbr1.getMin(d) - mbr2.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta;
        }
        return agg;
    }

    private double preNorm(NumberVector v, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v.doubleValue(d);
            agg += xd * xd;
        }
        return agg;
    }

    private double preNorm(double[] v, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v[d];
            agg += xd * xd;
        }
        return agg;
    }

    private double preNormMBR(SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr.getMin(d);
            double d2 = delta = delta >= 0.0 ? delta : -mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta;
        }
        return agg;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = this.preDistance(v1, v2, 0, mindim);
        if (dim1 > mindim) {
            agg += this.preNorm(v1, mindim, dim1);
        } else if (dim2 > mindim) {
            agg += this.preNorm(v2, mindim, dim2);
        }
        return agg;
    }

    @Override
    public double distance(double[] v1, double[] v2) {
        int dim1 = v1.length;
        int dim2 = v2.length;
        int mindim = dim1 < dim2 ? dim1 : dim2;
        double agg = this.preDistance(v1, v2, 0, mindim);
        if (dim1 > mindim) {
            agg += this.preNorm(v1, mindim, dim1);
        } else if (dim2 > mindim) {
            agg += this.preNorm(v2, mindim, dim2);
        }
        return agg;
    }

    @Override
    public double norm(NumberVector v) {
        return this.preNorm(v, 0, v.getDimensionality());
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double agg;
        NumberVector v2;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        NumberVector v1 = mbr1 instanceof NumberVector ? (NumberVector)mbr1 : null;
        NumberVector numberVector = v2 = mbr2 instanceof NumberVector ? (NumberVector)mbr2 : null;
        double d = v1 != null ? (v2 != null ? this.preDistance(v1, v2, 0, mindim) : this.preDistanceVM(v1, mbr2, 0, mindim)) : (agg = v2 != null ? this.preDistanceVM(v2, mbr1, 0, mindim) : this.preDistanceMBR(mbr1, mbr2, 0, mindim));
        if (dim1 > mindim) {
            agg += v1 != null ? this.preNorm(v1, mindim, dim1) : this.preNormMBR(mbr1, mindim, dim1);
        }
        if (dim2 > mindim) {
            agg += v2 != null ? this.preNorm(v2, mindim, dim2) : this.preNormMBR(mbr2, mindim, dim2);
        }
        return agg;
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    public String toString() {
        return "SquaredEuclideanDistance";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SquaredEuclideanDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

