/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import net.jafama.FastMath;

public class WeightedEuclideanDistanceFunction
extends WeightedLPNormDistanceFunction {
    public WeightedEuclideanDistanceFunction(double[] weights) {
        super(2.0, weights);
    }

    private double preDistance(NumberVector v1, NumberVector v2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v1.doubleValue(d);
            double yd = v2.doubleValue(d);
            double delta = xd - yd;
            agg += delta * delta * this.weights[d];
        }
        return agg;
    }

    private double preDistanceVM(NumberVector v, SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double value = v.doubleValue(d);
            double min = mbr.getMin(d);
            double delta = min - value;
            double d2 = delta = delta >= 0.0 ? delta : value - mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta * this.weights[d];
        }
        return agg;
    }

    private double preDistanceMBR(SpatialComparable mbr1, SpatialComparable mbr2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr2.getMin(d) - mbr1.getMax(d);
            double d2 = delta = delta >= 0.0 ? delta : mbr1.getMin(d) - mbr2.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta * this.weights[d];
        }
        return agg;
    }

    private double preNorm(NumberVector v, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v.doubleValue(d);
            agg += xd * xd * this.weights[d];
        }
        return agg;
    }

    private double preNormMBR(SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr.getMin(d);
            double d2 = delta = delta >= 0.0 ? delta : -mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += delta * delta * this.weights[d];
        }
        return agg;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = this.preDistance(v1, v2, 0, mindim);
        if (dim1 > mindim) {
            agg += this.preNorm(v1, mindim, dim1);
        } else if (dim2 > mindim) {
            agg += this.preNorm(v2, mindim, dim2);
        }
        return FastMath.sqrt(agg);
    }

    @Override
    public double norm(NumberVector v) {
        return FastMath.sqrt(this.preNorm(v, 0, v.getDimensionality()));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double agg;
        NumberVector v2;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        NumberVector v1 = mbr1 instanceof NumberVector ? (NumberVector)mbr1 : null;
        NumberVector numberVector = v2 = mbr2 instanceof NumberVector ? (NumberVector)mbr2 : null;
        double d = v1 != null ? (v2 != null ? this.preDistance(v1, v2, 0, mindim) : this.preDistanceVM(v1, mbr2, 0, mindim)) : (agg = v2 != null ? this.preDistanceVM(v2, mbr1, 0, mindim) : this.preDistanceMBR(mbr1, mbr2, 0, mindim));
        if (dim1 > mindim) {
            agg += v1 != null ? this.preNorm(v1, mindim, dim1) : this.preNormMBR(mbr1, mindim, dim1);
        }
        if (dim2 > mindim) {
            agg += v2 != null ? this.preNorm(v2, mindim, dim2) : this.preNormMBR(mbr2, mindim, dim2);
        }
        return FastMath.sqrt(agg);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter weightsP = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (config.grab(weightsP)) {
                this.weights = (double[])((double[])weightsP.getValue()).clone();
            }
        }

        @Override
        protected WeightedEuclideanDistanceFunction makeInstance() {
            return new WeightedEuclideanDistanceFunction(this.weights);
        }
    }
}

