/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedMaximumDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedLPNormDistanceFunction"})
public class WeightedLPNormDistanceFunction
extends LPNormDistanceFunction
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    protected double[] weights;

    public WeightedLPNormDistanceFunction(double p, double[] weights) {
        super(p);
        this.weights = weights;
    }

    private double preDistance(NumberVector v1, NumberVector v2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double yd;
            double xd = v1.doubleValue(d);
            double delta = xd >= (yd = v2.doubleValue(d)) ? xd - yd : yd - xd;
            agg += FastMath.pow(delta, this.p) * this.weights[d];
        }
        return agg;
    }

    private double preDistanceVM(NumberVector v, SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double value = v.doubleValue(d);
            double min = mbr.getMin(d);
            double delta = min - value;
            double d2 = delta = delta >= 0.0 ? delta : value - mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += FastMath.pow(delta, this.p) * this.weights[d];
        }
        return agg;
    }

    private double preDistanceMBR(SpatialComparable mbr1, SpatialComparable mbr2, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr2.getMin(d) - mbr1.getMax(d);
            double d2 = delta = delta >= 0.0 ? delta : mbr1.getMin(d) - mbr2.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += FastMath.pow(delta, this.p) * this.weights[d];
        }
        return agg;
    }

    private double preNorm(NumberVector v, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double xd = v.doubleValue(d);
            double delta = xd >= 0.0 ? xd : -xd;
            agg += FastMath.pow(delta, this.p) * this.weights[d];
        }
        return agg;
    }

    private double preNormMBR(SpatialComparable mbr, int start, int end) {
        double agg = 0.0;
        for (int d = start; d < end; ++d) {
            double delta = mbr.getMin(d);
            double d2 = delta = delta >= 0.0 ? delta : -mbr.getMax(d);
            if (!(delta > 0.0)) continue;
            agg += FastMath.pow(delta, this.p) * this.weights[d];
        }
        return agg;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = this.preDistance(v1, v2, 0, mindim);
        if (dim1 > mindim) {
            agg += this.preNorm(v1, mindim, dim1);
        } else if (dim2 > mindim) {
            agg += this.preNorm(v2, mindim, dim2);
        }
        return FastMath.pow(agg, this.invp);
    }

    @Override
    public double norm(NumberVector v) {
        return FastMath.pow(this.preNorm(v, 0, v.getDimensionality()), this.invp);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double agg;
        NumberVector v2;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        NumberVector v1 = mbr1 instanceof NumberVector ? (NumberVector)mbr1 : null;
        NumberVector numberVector = v2 = mbr2 instanceof NumberVector ? (NumberVector)mbr2 : null;
        double d = v1 != null ? (v2 != null ? this.preDistance(v1, v2, 0, mindim) : this.preDistanceVM(v1, mbr2, 0, mindim)) : (agg = v2 != null ? this.preDistanceVM(v2, mbr1, 0, mindim) : this.preDistanceMBR(mbr1, mbr2, 0, mindim));
        if (dim1 > mindim) {
            agg += v1 != null ? this.preNorm(v1, mindim, dim1) : this.preNormMBR(mbr1, mindim, dim1);
        }
        if (dim2 > mindim) {
            agg += v2 != null ? this.preNorm(v2, mindim, dim2) : this.preNormMBR(mbr2, mindim, dim2);
        }
        return FastMath.pow(agg, this.invp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof WeightedLPNormDistanceFunction)) {
            return false;
        }
        WeightedLPNormDistanceFunction other = (WeightedLPNormDistanceFunction)obj;
        return this.p == other.p && Arrays.equals(this.weights, other.weights);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, 0, this.weights.length);
    }

    public static class Parameterizer
    extends LPNormDistanceFunction.Parameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter weightsP = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (config.grab(weightsP)) {
                this.weights = (double[])((double[])weightsP.getValue()).clone();
            }
        }

        @Override
        protected WeightedLPNormDistanceFunction makeInstance() {
            return this.p == 1.0 ? new WeightedManhattanDistanceFunction(this.weights) : (this.p == 2.0 ? new WeightedEuclideanDistanceFunction(this.weights) : (this.p == Double.POSITIVE_INFINITY ? new WeightedMaximumDistanceFunction(this.weights) : new WeightedLPNormDistanceFunction(this.p, this.weights)));
        }
    }
}

