/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedSquaredEuclideanDistanceFunction"})
public class WeightedSquaredEuclideanDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
WeightedNumberVectorDistanceFunction<NumberVector>,
Norm<NumberVector> {
    protected double[] weights;

    public WeightedSquaredEuclideanDistanceFunction(double[] weights) {
        this.weights = weights;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = WeightedSquaredEuclideanDistanceFunction.dimensionality(v1, v2, this.weights.length);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double delta = v1.doubleValue(d) - v2.doubleValue(d);
            agg += delta * delta * this.weights[d];
        }
        return agg;
    }

    @Override
    public double norm(NumberVector obj) {
        int dim = obj.getDimensionality();
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double delta = obj.doubleValue(dim);
            agg += delta * delta * this.weights[d];
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 instanceof NumberVector && mbr2 instanceof NumberVector) {
            return this.distance((NumberVector)mbr1, (NumberVector)mbr2);
        }
        int dim = WeightedSquaredEuclideanDistanceFunction.dimensionality(mbr1, mbr2, this.weights.length);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double diff;
            if (mbr1.getMax(d) < mbr2.getMin(d)) {
                diff = mbr2.getMin(d) - mbr1.getMax(d);
            } else {
                if (!(mbr1.getMin(d) > mbr2.getMax(d))) continue;
                diff = mbr1.getMin(d) - mbr2.getMax(d);
            }
            agg += diff * diff * this.weights[d];
        }
        return agg;
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedSquaredEuclideanDistanceFunction)) {
            if (obj.getClass().equals(SquaredEuclideanDistanceFunction.class)) {
                for (double d : this.weights) {
                    if (d == 1.0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        WeightedSquaredEuclideanDistanceFunction other = (WeightedSquaredEuclideanDistanceFunction)obj;
        return Arrays.equals(this.weights, other.weights);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter weightsP = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (config.grab(weightsP)) {
                this.weights = (double[])((double[])weightsP.getValue()).clone();
            }
        }

        @Override
        protected WeightedSquaredEuclideanDistanceFunction makeInstance() {
            return new WeightedSquaredEuclideanDistanceFunction(this.weights);
        }
    }
}

