/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic.ChiSquaredDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Alias(value={"chi"})
@Priority(value=100)
@References(value={@Reference(authors="J. Puzicha, J. M. Buhmann, Y. Rubner, C. Tomasi", title="Empirical evaluation of dissimilarity measures for color and texture", booktitle="Proc. 7th IEEE International Conference on Computer Vision", url="https://doi.org/10.1109/ICCV.1999.790412", bibkey="DBLP:conf/iccv/PuzichaRTB99"), @Reference(authors="D. M. Endres, J. E. Schindelin", title="A new metric for probability distributions", booktitle="IEEE Transactions on Information Theory, 49(7)", url="https://doi.org/10.1109/TIT.2003.813506", bibkey="DBLP:journals/tit/EndresS03")})
public class ChiDistanceFunction
extends ChiSquaredDistanceFunction {
    public static final ChiDistanceFunction STATIC = new ChiDistanceFunction();

    @Deprecated
    public ChiDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        return FastMath.sqrt(super.distance(v1, v2));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        return FastMath.sqrt(super.minDist(mbr1, mbr2));
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public boolean isSquared() {
        return false;
    }

    @Override
    public String toString() {
        return "ChiDistance";
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ChiDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

