/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"chisq"})
@Priority(value=100)
@Reference(authors="J. Puzicha, J. M. Buhmann, Y. Rubner, C. Tomasi", title="Empirical evaluation of dissimilarity measures for color and texture", booktitle="Proc. 7th IEEE International Conference on Computer Vision", url="https://doi.org/10.1109/ICCV.1999.790412", bibkey="DBLP:conf/iccv/PuzichaRTB99")
public class ChiSquaredDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final ChiSquaredDistanceFunction STATIC = new ChiSquaredDistanceFunction();

    @Deprecated
    public ChiSquaredDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        double xd;
        int d;
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 < (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double si;
            double yd;
            xd = v1.doubleValue(d);
            double di = xd - (yd = v2.doubleValue(d));
            if (!(di > 0.0) && !(di < 0.0) || !((si = xd + yd) > 0.0)) continue;
            agg += di * di / si;
        }
        for (d = mindim; d < dim1; ++d) {
            xd = v1.doubleValue(d);
            agg += xd == xd ? xd : 0.0;
        }
        for (d = mindim; d < dim2; ++d) {
            double yd = v2.doubleValue(d);
            agg += yd == yd ? yd : 0.0;
        }
        return 2.0 * agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double max1;
        double min1;
        int d;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double si;
            double diff;
            min1 = mbr1.getMin(d);
            max1 = mbr1.getMax(d);
            double min2 = mbr2.getMin(d);
            double max2 = mbr2.getMax(d);
            double d2 = min2 > max1 ? min2 - max1 : (diff = min1 > max2 ? min1 - max2 : 0.0);
            if (!(diff > 0.0) || !((si = max1 + max2) > 0.0)) continue;
            agg += diff * diff / si;
        }
        for (d = mindim; d < dim1; ++d) {
            min1 = mbr1.getMin(d);
            if (min1 > 0.0) {
                agg += min1;
                continue;
            }
            max1 = mbr1.getMax(d);
            if (!(max1 < 0.0)) continue;
            agg += max1;
        }
        for (d = mindim; d < dim2; ++d) {
            double min2 = mbr2.getMin(d);
            if (min2 > 0.0) {
                agg += min2;
                continue;
            }
            double max2 = mbr2.getMax(d);
            if (!(max2 < 0.0)) continue;
            agg += max2;
        }
        return 2.0 * agg;
    }

    public String toString() {
        return "ChiSquaredDistance";
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ChiSquaredDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

