/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@References(value={@Reference(authors="C. R. Rao", title="Information and the Accuracy Attainable in the Estimation of Statistical Parameters", booktitle="Bulletin of the Calcutta Mathematical Society 37(3)", bibkey="journals/bcalms/Rao45"), @Reference(authors="M.-M. Deza, E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances", url="https://doi.org/10.1007/978-3-642-00234-2", bibkey="doi:10.1007/978-3-642-00234-2")})
@Alias(value={"rao", "fisher-rao", "fisher"})
public class FisherRaoDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final FisherRaoDistanceFunction STATIC = new FisherRaoDistanceFunction();

    @Deprecated
    public FisherRaoDistanceFunction() {
    }

    @Override
    public double distance(NumberVector fv1, NumberVector fv2) {
        int dim2;
        int dim1 = fv1.getDimensionality();
        int mindim = dim1 < (dim2 = fv2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (int d = 0; d < mindim; ++d) {
            double v12 = fv1.doubleValue(d) * fv2.doubleValue(d);
            assert (v12 >= 0.0) : "This distance is not defined on negative values.";
            if (!(v12 > 0.0)) continue;
            agg += FastMath.sqrt(v12);
        }
        return agg >= 1.0 ? 0.0 : (agg <= -1.0 ? -Math.PI : 2.0 * FastMath.acos(agg));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (int d = 0; d < mindim; ++d) {
            double v12 = mbr1.getMax(d) * mbr2.getMax(d);
            assert (v12 >= 0.0) : "This distance is not defined on negative values.";
            if (!(v12 > 0.0)) continue;
            agg += FastMath.sqrt(v12);
        }
        return agg >= 1.0 ? 0.0 : (agg <= -1.0 ? -Math.PI : 2.0 * FastMath.acos(agg));
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected FisherRaoDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

