/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialPrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedPrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@References(value={@Reference(authors="E. Hellinger", title="Neue Begr\u00fcndung der Theorie quadratischer Formen von unendlichvielen Ver\u00e4nderlichen", booktitle="Journal f\u00fcr die reine und angewandte Mathematik", url="http://resolver.sub.uni-goettingen.de/purl?GDZPPN002166941", bibkey="journals/mathematik/Hellinger1909"), @Reference(authors="M.-M. Deza, E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances", url="https://doi.org/10.1007/978-3-642-00234-2", bibkey="doi:10.1007/978-3-642-00234-2")})
@Alias(value={"hellinger", "bhattacharyya"})
public class HellingerDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
NormalizedPrimitiveSimilarityFunction<NumberVector> {
    public static final HellingerDistanceFunction STATIC = new HellingerDistanceFunction();
    private static final String NON_NEGATIVE = "Hellinger distance requires non-negative values.";

    @Deprecated
    public HellingerDistanceFunction() {
    }

    @Override
    public double distance(NumberVector fv1, NumberVector fv2) {
        double v1;
        int d;
        int dim2;
        int dim1 = fv1.getDimensionality();
        int mindim = dim1 < (dim2 = fv2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            v1 = fv1.doubleValue(d);
            double v2 = fv2.doubleValue(d);
            assert (v1 >= 0.0 && v2 >= 0.0) : "Hellinger distance requires non-negative values.";
            if (v1 == v2) continue;
            double v = FastMath.sqrt(v1) - FastMath.sqrt(v2);
            agg += v * v;
        }
        for (d = mindim; d < dim1; ++d) {
            v1 = fv1.doubleValue(d);
            assert (v1 >= 0.0) : "Hellinger distance requires non-negative values.";
            agg += v1;
        }
        for (d = mindim; d < dim2; ++d) {
            double v2 = fv2.doubleValue(d);
            assert (v2 >= 0.0) : "Hellinger distance requires non-negative values.";
            agg += v2;
        }
        return MathUtil.SQRTHALF * FastMath.sqrt(agg);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double min1;
        int d;
        int dim2;
        int dim1 = mbr1.getDimensionality();
        int mindim = dim1 < (dim2 = mbr2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (d = 0; d < mindim; ++d) {
            double v;
            min1 = mbr1.getMin(d);
            double max1 = mbr1.getMax(d);
            double min2 = mbr2.getMin(d);
            double max2 = mbr2.getMax(d);
            assert (min1 >= 0.0 && min2 >= 0.0) : "Hellinger distance requires non-negative values.";
            if (max1 < min2) {
                v = FastMath.sqrt(max1) - FastMath.sqrt(min2);
                agg += v * v;
                continue;
            }
            if (!(max2 < min1)) continue;
            v = FastMath.sqrt(max2) - FastMath.sqrt(min1);
            agg += v * v;
        }
        for (d = mindim; d < dim1; ++d) {
            min1 = mbr1.getMin(d);
            assert (min1 >= 0.0) : "Hellinger distance requires non-negative values.";
            agg += min1;
        }
        for (d = mindim; d < dim2; ++d) {
            double min2 = mbr2.getMin(d);
            assert (min2 >= 0.0) : "Hellinger distance requires non-negative values.";
            agg += min2;
        }
        return MathUtil.SQRTHALF * FastMath.sqrt(agg);
    }

    @Override
    public double similarity(NumberVector o1, NumberVector o2) {
        int dim2;
        int dim1 = o1.getDimensionality();
        int mindim = dim1 < (dim2 = o2.getDimensionality()) ? dim1 : dim2;
        double agg = 0.0;
        for (int d = 0; d < mindim; ++d) {
            double v2;
            double v1 = o1.doubleValue(d);
            agg += v1 == (v2 = o2.doubleValue(d)) ? (v1 > 0.0 ? v1 : -v1) : (v1 == 0.0 || v2 == 0.0 ? 0.0 : FastMath.sqrt(v1 * v2));
        }
        return agg;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public <T extends NumberVector> SpatialPrimitiveDistanceSimilarityQuery<T> instantiate(Relation<T> database) {
        return new SpatialPrimitiveDistanceSimilarityQuery<NumberVector>(database, this, this);
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HellingerDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

