/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@References(value={@Reference(authors="H. Jeffreys", title="An invariant form for the prior probability in estimation problems", booktitle="Proc. Royal Society A: Mathematical, Physical and Engineering Sciences 186(1007)", url="https://doi.org/10.1098/rspa.1946.0056", bibkey="doi:10.1098/rspa.1946.0056"), @Reference(authors="J. Puzicha, J. M. Buhmann, Y. Rubner, C. Tomasi", title="Empirical evaluation of dissimilarity measures for color and texture", booktitle="Proc. 7th IEEE International Conference on Computer Vision", url="https://doi.org/10.1109/ICCV.1999.790412", bibkey="DBLP:conf/iccv/PuzichaRTB99"), @Reference(authors="F. Tops\u00f8e", title="Some inequalities for information divergence and related measures of discrimination", booktitle="IEEE Transactions on information theory, 46(4)", url="https://doi.org/10.1109/18.850703", bibkey="DBLP:journals/tit/Topsoe00"), @Reference(authors="D. M. Endres, J. E. Schindelin", title="A new metric for probability distributions", booktitle="IEEE Transactions on Information Theory 49(7)", url="https://doi.org/10.1109/TIT.2003.813506", bibkey="DBLP:journals/tit/EndresS03")})
@Alias(value={"j-divergence"})
public class JeffreyDivergenceDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final JeffreyDivergenceDistanceFunction STATIC = new JeffreyDivergenceDistanceFunction();

    @Deprecated
    public JeffreyDivergenceDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = JeffreyDivergenceDistanceFunction.dimensionality(v1, v2);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double md;
            double yd;
            double xd = v1.doubleValue(d);
            if (xd == (yd = v2.doubleValue(d)) || !((md = 0.5 * (xd + yd)) > 0.0)) continue;
            agg += (xd > 0.0 ? xd * FastMath.log(xd / md) : 0.0) + (yd > 0.0 ? yd * FastMath.log(yd / md) : 0.0);
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim = JeffreyDivergenceDistanceFunction.dimensionality(mbr1, mbr2);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double min1 = mbr1.getMin(d);
            double min2 = mbr2.getMin(d);
            double md = 0.5 * (mbr1.getMax(d) + mbr2.getMax(d));
            if (!(md > 0.0)) continue;
            agg += (min1 > 0.0 ? min1 * FastMath.log(min1 / md) : 0.0) + (min2 > 0.0 ? min2 * FastMath.log(min2 / md) : 0.0);
        }
        return agg > 0.0 ? agg : 0.0;
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    public String toString() {
        return "JeffreyDivergenceDistance";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected JeffreyDivergenceDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

