/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic.JeffreyDivergenceDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@References(value={@Reference(authors="J. Lin", title="Divergence measures based on the Shannon entropy", booktitle="IEEE Transactions on Information Theory 37(1)", url="https://doi.org/10.1109/18.61115", bibkey="DBLP:journals/tit/Lin91"), @Reference(authors="D. M. Endres, J. E. Schindelin", title="A new metric for probability distributions", booktitle="IEEE Transactions on Information Theory 49(7)", url="https://doi.org/10.1109/TIT.2003.813506", bibkey="DBLP:journals/tit/EndresS03"), @Reference(authors="M.-M. Deza, E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances", url="https://doi.org/10.1007/978-3-642-00234-2", bibkey="doi:10.1007/978-3-642-00234-2")})
public class JensenShannonDivergenceDistanceFunction
extends JeffreyDivergenceDistanceFunction {
    public static final JensenShannonDivergenceDistanceFunction STATIC = new JensenShannonDivergenceDistanceFunction();

    @Deprecated
    public JensenShannonDivergenceDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        return 0.5 * super.distance(v1, v2);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        return 0.5 * super.minDist(mbr1, mbr2);
    }

    @Override
    public String toString() {
        return "JensenShannonDivergenceDistance";
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected JensenShannonDivergenceDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

