/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="S. Kullback", title="Information theory and statistics", booktitle="", bibkey="books/dover/Kullback59")
@Alias(value={"kl"})
public class KullbackLeiblerDivergenceAsymmetricDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final KullbackLeiblerDivergenceAsymmetricDistanceFunction STATIC = new KullbackLeiblerDivergenceAsymmetricDistanceFunction();

    @Deprecated
    public KullbackLeiblerDivergenceAsymmetricDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = KullbackLeiblerDivergenceAsymmetricDistanceFunction.dimensionality(v1, v2);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double xd = v1.doubleValue(d);
            double yd = v2.doubleValue(d);
            if (yd <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (!(xd > 0.0)) continue;
            agg += xd * FastMath.log(xd / yd);
        }
        return agg;
    }

    @Override
    public boolean isSymmetric() {
        return false;
    }

    public String toString() {
        return "KullbackLeiblerDivergenceDistance";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected KullbackLeiblerDivergenceAsymmetricDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

