/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic.JensenShannonDivergenceDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="D. M. Endres, J. E. Schindelin", title="A new metric for probability distributions", booktitle="IEEE Transactions on Information Theory, 49(7)", url="https://doi.org/10.1109/TIT.2003.813506", bibkey="DBLP:journals/tit/EndresS03")
public class SqrtJensenShannonDivergenceDistanceFunction
extends JensenShannonDivergenceDistanceFunction {
    public static final SqrtJensenShannonDivergenceDistanceFunction STATIC = new SqrtJensenShannonDivergenceDistanceFunction();

    @Deprecated
    public SqrtJensenShannonDivergenceDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        return FastMath.sqrt(super.distance(v1, v2));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        return FastMath.sqrt(super.minDist(mbr1, mbr2));
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public boolean isSquared() {
        return false;
    }

    @Override
    public String toString() {
        return "SqrtJensenShannonDivergenceDistance";
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SqrtJensenShannonDivergenceDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

