/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="F. Tops\u00f8e", title="Some inequalities for information divergence and related measures of discrimination", booktitle="IEEE Transactions on information theory, 46(4)", url="https://doi.org/10.1109/18.850703", bibkey="DBLP:journals/tit/Topsoe00")
public class TriangularDiscriminationDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector> {
    public static final TriangularDiscriminationDistanceFunction STATIC = new TriangularDiscriminationDistanceFunction();

    @Deprecated
    public TriangularDiscriminationDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = TriangularDiscriminationDistanceFunction.dimensionality(v1, v2);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double yd;
            double xd = v1.doubleValue(d);
            double sum = xd + (yd = v2.doubleValue(d));
            if (!(sum > 0.0)) continue;
            double delta = xd - yd;
            agg += delta * delta / sum;
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim = TriangularDiscriminationDistanceFunction.dimensionality(mbr1, mbr2);
        double agg = 0.0;
        for (int d = 0; d < dim; ++d) {
            double min1 = mbr1.getMin(d);
            double max1 = mbr1.getMax(d);
            double min2 = mbr2.getMin(d);
            double max2 = mbr2.getMax(d);
            double sum = max1 + max2;
            if (!(sum > 0.0)) continue;
            double delta = min2 - max1;
            double d2 = delta = delta >= 0.0 ? delta : min1 - max2;
            if (!(delta > 0.0)) continue;
            agg += delta * delta / sum;
        }
        return agg;
    }

    @Override
    public boolean isSquared() {
        return true;
    }

    public String toString() {
        return "TriangularDiscriminationDistanceFunction";
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected TriangularDiscriminationDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

