/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic.TriangularDiscriminationDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="R. Connor, F. A. Cardillo, L. Vadicamo, F. Rabitti", title="Hilbert Exclusion: Improved Metric Search through Finite Isometric Embeddings", booktitle="arXiv preprint arXiv:1604.08640", url="http://arxiv.org/abs/1604.08640", bibkey="DBLP:journals/corr/ConnorCVR16")
public class TriangularDistanceFunction
extends TriangularDiscriminationDistanceFunction {
    public static final TriangularDistanceFunction STATIC = new TriangularDistanceFunction();

    @Deprecated
    private TriangularDistanceFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        return FastMath.sqrt(super.distance(v1, v2));
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        return FastMath.sqrt(super.minDist(mbr1, mbr2));
    }

    @Override
    public boolean isSquared() {
        return false;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public String toString() {
        return "TriangularDistanceFunction";
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected TriangularDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

