/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.set;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.set.AbstractSetDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="R. W. Hamming", title="Error detecting and error correcting codes", booktitle="Bell System technical journal, 29(2)", url="https://doi.org/10.1002/j.1538-7305.1950.tb00463.x", bibkey="doi:10.1002/j.1538-7305.1950.tb00463.x")
public class HammingDistanceFunction
extends AbstractSetDistanceFunction<FeatureVector<?>>
implements NumberVectorDistanceFunction<FeatureVector<?>> {
    public static final HammingDistanceFunction STATIC = new HammingDistanceFunction();

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public double distance(FeatureVector<?> o1, FeatureVector<?> o2) {
        Object v1;
        int d;
        if (o1 instanceof BitVector && o2 instanceof BitVector) {
            return ((BitVector)o1).hammingDistance((BitVector)o2);
        }
        if (o1 instanceof NumberVector && o2 instanceof NumberVector) {
            return this.hammingDistanceNumberVector((NumberVector)o1, (NumberVector)o2);
        }
        int d1 = o1.getDimensionality();
        int d2 = o2.getDimensionality();
        int differences = 0;
        for (d = 0; d < d1 && d < d2; ++d) {
            v1 = o1.getValue(d);
            Object v2 = o2.getValue(d);
            boolean n1 = HammingDistanceFunction.isNull(v1);
            boolean n2 = HammingDistanceFunction.isNull(v2);
            if (n1 && n2 || v1 instanceof Double && Double.isNaN((Double)v1) || v2 instanceof Double && Double.isNaN((Double)v2) || !n1 && !n2 && v1.equals(v2)) continue;
            ++differences;
        }
        while (d < d1) {
            v1 = o1.getValue(d);
            if (!(HammingDistanceFunction.isNull(v1) || v1 instanceof Double && Double.isNaN((Double)v1))) {
                ++differences;
            }
            ++d;
        }
        while (d < d2) {
            Object v2 = o2.getValue(d);
            if (!(HammingDistanceFunction.isNull(v2) || v2 instanceof Double && Double.isNaN((Double)v2))) {
                ++differences;
            }
            ++d;
        }
        return differences;
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        if (o1 instanceof BitVector && o2 instanceof BitVector) {
            return ((BitVector)o1).hammingDistance((BitVector)o2);
        }
        return this.hammingDistanceNumberVector(o1, o2);
    }

    private double hammingDistanceNumberVector(NumberVector o1, NumberVector o2) {
        double v1;
        int d;
        int d1 = o1.getDimensionality();
        int d2 = o2.getDimensionality();
        int differences = 0;
        for (d = 0; d < d1 && d < d2; ++d) {
            v1 = o1.doubleValue(d);
            double v2 = o2.doubleValue(d);
            if (v1 != v1 || v2 != v2 || v1 == v2) continue;
            ++differences;
        }
        while (d < d1) {
            v1 = o1.doubleValue(d);
            if (v1 != 0.0 && v1 == v1) {
                ++differences;
            }
            ++d;
        }
        while (d < d2) {
            double v2 = o2.doubleValue(d);
            if (v2 != 0.0 && v2 == v2) {
                ++differences;
            }
            ++d;
        }
        return differences;
    }

    @Override
    public SimpleTypeInformation<? super FeatureVector<?>> getInputTypeRestriction() {
        return FeatureVector.TYPE;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HammingDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

