/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.set;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.set.AbstractSetDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedPrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Jaccard", title="Distribution de la florine alpine dans la Bassin de Dranses et dans quelques regiones voisines", booktitle="Bulletin del la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles", url="http://data.rero.ch/01-R241574160", bibkey="journals/misc/Jaccard1902")
@Alias(value={"de.lmu.ifi.dbs.elki.distance.similarityfunction.JaccardPrimitiveSimilarityFunction"})
public class JaccardSimilarityDistanceFunction
extends AbstractSetDistanceFunction<FeatureVector<?>>
implements NormalizedPrimitiveSimilarityFunction<FeatureVector<?>>,
NumberVectorDistanceFunction<FeatureVector<?>>,
PrimitiveDistanceFunction<FeatureVector<?>> {
    @Override
    public double similarity(FeatureVector<?> o1, FeatureVector<?> o2) {
        Object v1;
        int d;
        if (o1 instanceof BitVector && o2 instanceof BitVector) {
            return ((BitVector)o1).jaccardSimilarity((BitVector)o2);
        }
        if (o1 instanceof NumberVector && o2 instanceof NumberVector) {
            return JaccardSimilarityDistanceFunction.similarityNumberVector((NumberVector)o1, (NumberVector)o2);
        }
        int d1 = o1.getDimensionality();
        int d2 = o2.getDimensionality();
        int intersection = 0;
        int union = 0;
        for (d = 0; d < d1 && d < d2; ++d) {
            v1 = o1.getValue(d);
            Object v2 = o2.getValue(d);
            boolean n1 = JaccardSimilarityDistanceFunction.isNull(v1);
            boolean n2 = JaccardSimilarityDistanceFunction.isNull(v2);
            if (v1 instanceof Double && Double.isNaN((Double)v1) || v2 instanceof Double && Double.isNaN((Double)v2) || n1 && n2) continue;
            ++union;
            if (n1 || !v1.equals(v2)) continue;
            ++intersection;
        }
        while (d < d1) {
            v1 = o1.getValue(d);
            if (!(JaccardSimilarityDistanceFunction.isNull(v1) || v1 instanceof Double && Double.isNaN((Double)v1))) {
                ++union;
            }
            ++d;
        }
        while (d < d2) {
            Object v2 = o2.getValue(d);
            if (!(JaccardSimilarityDistanceFunction.isNull(v2) || v2 instanceof Double && Double.isNaN((Double)v2))) {
                ++union;
            }
            ++d;
        }
        return (double)intersection / (double)union;
    }

    public static double similarityNumberVector(NumberVector o1, NumberVector o2) {
        int d;
        int d1 = o1.getDimensionality();
        int d2 = o2.getDimensionality();
        int intersection = 0;
        int union = 0;
        for (d = 0; d < d1 && d < d2; ++d) {
            double v1 = o1.doubleValue(d);
            double v2 = o2.doubleValue(d);
            if (v1 != v1 || v2 != v2 || v1 == 0.0 && v2 == 0.0) continue;
            ++union;
            if (v1 != v2) continue;
            ++intersection;
        }
        while (d < d1) {
            if (o1.doubleValue(d) != 0.0) {
                ++union;
            }
            ++d;
        }
        while (d < d2) {
            if (o2.doubleValue(d) != 0.0) {
                ++union;
            }
            ++d;
        }
        return (double)intersection / (double)union;
    }

    @Override
    public double distance(FeatureVector<?> o1, FeatureVector<?> o2) {
        return 1.0 - this.similarity(o1, o2);
    }

    @Override
    public double distance(NumberVector o1, NumberVector o2) {
        if (o1 instanceof BitVector && o2 instanceof BitVector) {
            return 1.0 - ((BitVector)o1).jaccardSimilarity((BitVector)o2);
        }
        return 1.0 - JaccardSimilarityDistanceFunction.similarityNumberVector(o1, o2);
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public SimpleTypeInformation<? super FeatureVector<?>> getInputTypeRestriction() {
        return FeatureVector.TYPE;
    }

    @Override
    public <T extends FeatureVector<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

