/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.strings;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Description(value="Levenshtein distance.")
@Reference(authors="V. I. Levenshtein", title="Binary codes capable of correcting deletions, insertions and reversals", booktitle="Soviet physics doklady 10", bibkey="journals/misc/Levenshtein66")
public class LevenshteinDistanceFunction
implements PrimitiveDistanceFunction<String> {
    public static final LevenshteinDistanceFunction STATIC_SENSITIVE = new LevenshteinDistanceFunction();
    protected static final SimpleTypeInformation<? super String> TYPE = new SimpleTypeInformation<String>(String.class);

    @Deprecated
    public LevenshteinDistanceFunction() {
    }

    @Override
    public double distance(String o1, String o2) {
        return LevenshteinDistanceFunction.levenshteinDistance(o1, o2);
    }

    public static int levenshteinDistance(String o1, String o2) {
        int l2;
        if (o1.length() > o2.length()) {
            return LevenshteinDistanceFunction.levenshteinDistance(o2, o1);
        }
        int l1 = o1.length();
        if (l1 == (l2 = o2.length()) && o1.hashCode() == o2.hashCode() && o1.equals(o2)) {
            return 0;
        }
        int prefix = LevenshteinDistanceFunction.prefixLen(o1, o2);
        if (prefix == l1 || prefix == l2) {
            return Math.abs(l1 - l2);
        }
        int postfix = LevenshteinDistanceFunction.postfixLen(o1, o2, prefix);
        return prefix + postfix == l1 || prefix + postfix == l2 ? Math.abs(l1 - l2) : (l1 == l2 && prefix + postfix + 1 == l1 ? 1 : LevenshteinDistanceFunction.levenshteinDistance(o1, o2, prefix, postfix));
    }

    private static int prefixLen(String o1, String o2) {
        int prefix;
        int l2;
        int l1 = o1.length();
        int l = l1 < (l2 = o2.length()) ? l1 : l2;
        for (prefix = 0; prefix < l && o1.charAt(prefix) == o2.charAt(prefix); ++prefix) {
        }
        return prefix;
    }

    private static int postfixLen(String o1, String o2, int prefix) {
        int postfix = 0;
        int p1 = o1.length();
        int p2 = o2.length();
        while (p1 > prefix && p2 > prefix && o1.charAt(--p1) == o2.charAt(--p2)) {
            ++postfix;
        }
        return postfix;
    }

    public static int levenshteinDistance(String o1, String o2, int prefix, int postfix) {
        int l1 = o1.length();
        int l2 = o2.length();
        int[] buf = new int[l2 + 1 - (prefix + postfix) << 1];
        for (int j = 0; j < buf.length; j += 2) {
            buf[j] = j >> 1;
        }
        int inter = 1;
        int i = prefix;
        int e1 = l1 - postfix;
        while (i < e1) {
            char chr = o1.charAt(i);
            buf[inter] = i + 1 - prefix;
            int c = 2 + inter;
            int p = 3 - inter;
            int j = prefix;
            while (c < buf.length) {
                buf[c] = LevenshteinDistanceFunction.min(buf[p] + 1, buf[c - 2] + 1, buf[p - 2] + (chr == o2.charAt(j++) ? 0 : 1));
                c += 2;
                p += 2;
            }
            ++i;
            inter ^= 1;
        }
        return buf[buf.length - 2 + (inter ^ 1)];
    }

    private static int min(int a, int b, int c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    @Override
    public SimpleTypeInformation<? super String> getInputTypeRestriction() {
        return TYPE;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LevenshteinDistanceFunction makeInstance() {
            return STATIC_SENSITIVE;
        }
    }
}

