/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.strings;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.strings.LevenshteinDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Description(value="Levenshtein distance, normalized by average string length.")
@Reference(authors="V. I. Levenshtein", title="Binary codes capable of correcting deletions, insertions and reversals", booktitle="Soviet physics doklady 10", bibkey="journals/misc/Levenshtein66")
public class NormalizedLevenshteinDistanceFunction
implements PrimitiveDistanceFunction<String> {
    public static final NormalizedLevenshteinDistanceFunction STATIC_SENSITIVE = new NormalizedLevenshteinDistanceFunction();

    @Deprecated
    public NormalizedLevenshteinDistanceFunction() {
    }

    @Override
    public double distance(String o1, String o2) {
        int cost = LevenshteinDistanceFunction.levenshteinDistance(o1, o2);
        return (double)cost * 2.0 / (double)(o1.length() + o2.length());
    }

    @Override
    public SimpleTypeInformation<? super String> getInputTypeRestriction() {
        return LevenshteinDistanceFunction.TYPE;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalizedLevenshteinDistanceFunction makeInstance() {
            return STATIC_SENSITIVE;
        }
    }
}

