/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionSelectingSubspaceDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionSelectingDistanceFunction"})
public class OnedimensionalDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
DimensionSelectingSubspaceDistanceFunction<NumberVector>,
Norm<NumberVector> {
    private int dim;

    public OnedimensionalDistanceFunction(int dim) {
        this.dim = dim;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        if (this.dim >= v1.getDimensionality() || this.dim >= v2.getDimensionality() || this.dim < 0) {
            throw new IllegalArgumentException("Specified dimension to be considered is larger that dimensionality of FeatureVectors:\n  first argument: " + v1.toString() + "\n  second argument: " + v2.toString() + "\n  dimension: " + this.dim);
        }
        double delta = v1.doubleValue(this.dim) - v2.doubleValue(this.dim);
        return delta >= 0.0 ? delta : -delta;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        double max2;
        double min2;
        if (this.dim >= mbr1.getDimensionality() || this.dim >= mbr2.getDimensionality() || this.dim < 0) {
            throw new IllegalArgumentException("Specified dimension to be considered is larger that dimensionality of FeatureVectors:\n  first argument: " + mbr1.toString() + "\n  second argument: " + mbr2.toString() + "\n  dimension: " + this.dim);
        }
        double max1 = mbr1.getMax(this.dim);
        if (max1 < (min2 = mbr2.getMin(this.dim))) {
            return min2 - max1;
        }
        double min1 = mbr1.getMin(this.dim);
        if (min1 > (max2 = mbr2.getMax(this.dim))) {
            return min1 - max2;
        }
        return 0.0;
    }

    @Override
    public double norm(NumberVector obj) {
        return Math.abs(obj.doubleValue(this.dim));
    }

    public int getSelectedDimension() {
        return this.dim;
    }

    @Override
    @Deprecated
    public long[] getSelectedDimensions() {
        long[] bs = BitsUtil.zero(this.dim);
        BitsUtil.setI(bs, this.dim);
        return bs;
    }

    @Override
    @Deprecated
    public void setSelectedDimensions(long[] dimensions) {
        this.dim = BitsUtil.nextSetBit(dimensions, 0);
        if (this.dim == -1) {
            throw new IllegalArgumentException("No dimension was set.");
        }
        if (BitsUtil.nextSetBit(dimensions, this.dim + 1) > 0) {
            throw new IllegalArgumentException("More than one dimension was set.");
        }
    }

    @Override
    public VectorTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, this.dim, Integer.MAX_VALUE);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass()) && this.dim == ((OnedimensionalDistanceFunction)obj).dim;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.dim * 31;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("dim", "an integer between 1 and the dimensionality of the feature space 1 specifying the dimension to be considered for distance computation.");
        protected int dim = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter dimP = (IntParameter)new IntParameter(DIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(dimP)) {
                this.dim = (Integer)dimP.getValue();
            }
        }

        @Override
        protected OnedimensionalDistanceFunction makeInstance() {
            return new OnedimensionalDistanceFunction(this.dim);
        }
    }
}

