/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.AbstractDimensionsSelectingDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import java.util.Arrays;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionsSelectingEuclideanDistanceFunction"})
public class SubspaceEuclideanDistanceFunction
extends SubspaceLPNormDistanceFunction {
    public SubspaceEuclideanDistanceFunction(long[] dimensions) {
        super(2.0, dimensions);
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        if (v1.getDimensionality() != v2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of FeatureVectors\n  first argument: " + v1 + "\n  second argument: " + v2);
        }
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double delta = v1.doubleValue(d) - v2.doubleValue(d);
            sqrDist += delta * delta;
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.sqrt(sqrDist);
    }

    @Override
    protected double minDistObject(SpatialComparable mbr, NumberVector v) {
        if (mbr.getDimensionality() != v.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + mbr.toString() + "\n  second argument: " + v.toString());
        }
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double omin;
            double value = v.doubleValue(d);
            if (value < (omin = mbr.getMin(d))) {
                double delta = omin - value;
                sqrDist += delta * delta;
            } else {
                double omax = mbr.getMax(d);
                if (value > omax) {
                    double delta = value - omax;
                    sqrDist += delta * delta;
                }
            }
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.sqrt(sqrDist);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1.getDimensionality() != mbr2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + mbr1.toString() + "\n  second argument: " + mbr2.toString());
        }
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double min2;
            double max1 = mbr1.getMax(d);
            if (max1 < (min2 = mbr2.getMin(d))) {
                double delta = min2 - max1;
                sqrDist += delta * delta;
            } else {
                double max2;
                double min1 = mbr1.getMin(d);
                if (min1 > (max2 = mbr2.getMax(d))) {
                    double delta = min1 - max2;
                    sqrDist += delta * delta;
                }
            }
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.sqrt(sqrDist);
    }

    @Override
    public double norm(NumberVector obj) {
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double delta = obj.doubleValue(d);
            sqrDist += delta * delta;
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.sqrt(sqrDist);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this.dimensions, ((SubspaceEuclideanDistanceFunction)obj).dimensions);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + BitsUtil.hashCode(this.dimensions);
    }

    public static class Parameterizer
    extends AbstractDimensionsSelectingDistanceFunction.Parameterizer {
        @Override
        protected SubspaceEuclideanDistanceFunction makeInstance() {
            return new SubspaceEuclideanDistanceFunction(this.dimensions);
        }
    }
}

