/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialPrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.AbstractDimensionsSelectingDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;
import net.jafama.FastMath;

public class SubspaceLPNormDistanceFunction
extends AbstractDimensionsSelectingDistanceFunction<NumberVector>
implements SpatialPrimitiveDistanceFunction<NumberVector>,
Norm<NumberVector>,
NumberVectorDistanceFunction<NumberVector> {
    private double p;

    public SubspaceLPNormDistanceFunction(double p, long[] dimensions) {
        super(dimensions);
        this.p = p;
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double delta = Math.abs(v1.doubleValue(d) - v2.doubleValue(d));
            sqrDist += FastMath.pow(delta, this.p);
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.pow(sqrDist, 1.0 / this.p);
    }

    protected double minDistObject(SpatialComparable mbr, NumberVector v) {
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double omin;
            double value = v.doubleValue(d);
            if (value < (omin = mbr.getMin(d))) {
                sqrDist += FastMath.pow(omin - value, this.p);
            } else {
                double omax = mbr.getMax(d);
                if (value > omax) {
                    sqrDist += FastMath.pow(value - omax, this.p);
                }
            }
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.pow(sqrDist, 1.0 / this.p);
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1.getDimensionality() != mbr2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + mbr1.toString() + "\n  second argument: " + mbr2.toString());
        }
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double min2;
            double max1 = mbr1.getMax(d);
            if (max1 < (min2 = mbr2.getMin(d))) {
                sqrDist += FastMath.pow(min2 - max1, this.p);
            } else {
                double max2;
                double min1 = mbr1.getMin(d);
                if (min1 > (max2 = mbr2.getMax(d))) {
                    sqrDist += FastMath.pow(min1 - max2, this.p);
                }
            }
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.pow(sqrDist, 1.0 / this.p);
    }

    @Override
    public double norm(NumberVector obj) {
        double sqrDist = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            sqrDist += FastMath.pow(Math.abs(obj.doubleValue(d)), this.p);
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return FastMath.pow(sqrDist, 1.0 / this.p);
    }

    @Override
    public <T extends NumberVector> SpatialPrimitiveDistanceQuery<T> instantiate(Relation<T> database) {
        return new SpatialPrimitiveDistanceQuery<NumberVector>((Relation<NumberVector>)database, this);
    }

    @Override
    public VectorFieldTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.FIELD;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this.dimensions, ((SubspaceLPNormDistanceFunction)obj).dimensions) && this.p == ((SubspaceLPNormDistanceFunction)obj).p;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + BitsUtil.hashCode(this.dimensions) + Double.hashCode(this.p);
    }

    public static class Parameterizer
    extends AbstractDimensionsSelectingDistanceFunction.Parameterizer {
        private double p;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter paramP = (DoubleParameter)new DoubleParameter(LPNormDistanceFunction.Parameterizer.P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(paramP)) {
                this.p = (Double)paramP.getValue();
            }
            super.makeOptions(config);
        }

        @Override
        protected SubspaceLPNormDistanceFunction makeInstance() {
            return this.p == 2.0 ? new SubspaceEuclideanDistanceFunction(this.dimensions) : (this.p == 1.0 ? new SubspaceManhattanDistanceFunction(this.dimensions) : new SubspaceLPNormDistanceFunction(this.p, this.dimensions));
        }
    }
}

