/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.AbstractDimensionsSelectingDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import java.util.Arrays;

public class SubspaceMaximumDistanceFunction
extends SubspaceLPNormDistanceFunction {
    public SubspaceMaximumDistanceFunction(long[] dimensions) {
        super(Double.POSITIVE_INFINITY, dimensions);
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        if (v1.getDimensionality() != v2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of FeatureVectors\n  first argument: " + v1 + "\n  second argument: " + v2);
        }
        double agg = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double v = Math.abs(v1.doubleValue(d) - v2.doubleValue(d));
            agg = v > agg ? v : agg;
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return agg;
    }

    @Override
    protected double minDistObject(SpatialComparable mbr, NumberVector v) {
        if (mbr.getDimensionality() != v.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + mbr.toString() + "\n  second argument: " + v.toString());
        }
        double agg = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double diff2;
            double value = v.doubleValue(d);
            double diff1 = mbr.getMin(d) - value;
            agg = diff1 > 0.0 ? (diff1 > agg ? diff1 : agg) : ((diff2 = value - mbr.getMax(d)) > agg ? diff2 : agg);
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return agg;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1.getDimensionality() != mbr2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + mbr1.toString() + "\n  second argument: " + mbr2.toString());
        }
        double agg = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double max2;
            double min1;
            double v;
            double v2;
            double min2;
            double max1 = mbr1.getMax(d);
            agg = max1 < (min2 = mbr2.getMin(d)) ? ((v2 = min2 - max1) > agg ? v2 : agg) : ((v = (min1 = mbr1.getMin(d)) - (max2 = mbr2.getMax(d))) > agg ? v : agg);
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return agg;
    }

    @Override
    public double norm(NumberVector obj) {
        double agg = 0.0;
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            double v = Math.abs(obj.doubleValue(d));
            agg = v > agg ? v : agg;
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        return agg;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this.dimensions, ((SubspaceMaximumDistanceFunction)obj).dimensions);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + BitsUtil.hashCode(this.dimensions);
    }

    public static class Parameterizer
    extends AbstractDimensionsSelectingDistanceFunction.Parameterizer {
        @Override
        protected SubspaceMaximumDistanceFunction makeInstance() {
            return new SubspaceMaximumDistanceFunction(this.dimensions);
        }
    }
}

