/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public abstract class AbstractEditDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    protected double bandSize;

    public AbstractEditDistanceFunction(double bandSize) {
        this.bandSize = bandSize;
    }

    protected int effectiveBandSize(int dim1, int dim2) {
        if (this.bandSize == Double.POSITIVE_INFINITY) {
            return dim1 > dim2 ? dim1 : dim2;
        }
        if (this.bandSize >= 1.0) {
            return (int)this.bandSize;
        }
        return (int)Math.ceil((double)(dim1 >= dim2 ? dim1 : dim2) * this.bandSize);
    }

    @Override
    public VectorTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this.bandSize == ((AbstractEditDistanceFunction)obj).bandSize;
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + Double.hashCode(this.bandSize);
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID BANDSIZE_ID = new OptionID("edit.bandsize", "The band size for time series alignment. By default, no constraint is used. If the value is larger than 0, it will be considered absolute, otherwise relative to the longer sequence. Note that 0 does not make sense: use Euclidean distance then instead.");
        protected double bandSize = Double.POSITIVE_INFINITY;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter bandSizeP = (DoubleParameter)((DoubleParameter)new DoubleParameter(BANDSIZE_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(bandSizeP)) {
                this.bandSize = bandSizeP.doubleValue();
            }
        }
    }
}

