/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.AbstractEditDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;
import net.jafama.FastMath;

@Title(value="Dynamic Time Warping Distance Function")
@Reference(authors="D. Berndt, J. Clifford", title="Using dynamic time warping to find patterns in time series", booktitle="AAAI-94 Workshop on Knowledge Discovery in Databases, 1994", url="http://www.aaai.org/Papers/Workshops/1994/WS-94-03/WS94-03-031.pdf", bibkey="DBLP:conf/kdd/BerndtC94")
public class DTWDistanceFunction
extends AbstractEditDistanceFunction {
    public DTWDistanceFunction() {
        this(Double.POSITIVE_INFINITY);
    }

    public DTWDistanceFunction(double bandSize) {
        super(bandSize);
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim1 = v1.getDimensionality();
        int dim2 = v2.getDimensionality();
        int m2 = dim2 - 1;
        int band = this.effectiveBandSize(dim1, dim2);
        if (Math.abs(dim1 - dim2) > band) {
            return Double.POSITIVE_INFINITY;
        }
        double[] buf = new double[dim2 << 1];
        Arrays.fill(buf, Double.POSITIVE_INFINITY);
        this.firstRow(buf, band, v1, v2, dim2);
        int cur = 0;
        int nxt = dim2;
        int i = 1;
        int l = 0;
        int r = Math.min(m2, i + band);
        while (i < dim1) {
            double val1 = v1.doubleValue(i);
            for (int j = l; j <= r; ++j) {
                double min = buf[cur + j];
                if (j > 0) {
                    double pij = buf[cur + j - 1];
                    double d = min = pij < min ? pij : min;
                    if (j > l) {
                        double pj = buf[nxt + j - 1];
                        min = pj < min ? pj : min;
                    }
                }
                buf[nxt + j] = min + this.delta(val1, v2.doubleValue(j));
            }
            cur = dim2 - cur;
            nxt = dim2 - nxt;
            if (++i > band) {
                ++l;
            }
            if (r >= m2) continue;
            ++r;
        }
        return FastMath.sqrt(buf[cur + dim2 - 1]);
    }

    protected void firstRow(double[] buf, int band, NumberVector v1, NumberVector v2, int dim2) {
        double val1 = v1.doubleValue(0);
        buf[0] = this.delta(val1, v2.doubleValue(0));
        int w = band >= dim2 ? dim2 - 1 : band;
        for (int j = 1; j <= w; ++j) {
            buf[j] = buf[j - 1] + this.delta(val1, v2.doubleValue(j));
        }
    }

    protected double delta(double val1, double val2) {
        double diff = val1 - val2;
        return diff * diff;
    }

    public static class Parameterizer
    extends AbstractEditDistanceFunction.Parameterizer {
        @Override
        protected DTWDistanceFunction makeInstance() {
            return new DTWDistanceFunction(this.bandSize);
        }
    }
}

