/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.DTWDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;
import net.jafama.FastMath;

@Title(value="Derivative dynamic time warping")
@Reference(authors="E. J. Keogh, M. J. Pazzani", title="Derivative dynamic time warping", booktitle="1st SIAM Int. Conf. on Data Mining (SDM-2001)", url="https://doi.org/10.1137/1.9781611972719.1", bibkey="DBLP:conf/sdm/KeoghP01")
public class DerivativeDTWDistanceFunction
extends DTWDistanceFunction {
    public DerivativeDTWDistanceFunction() {
        this(Double.POSITIVE_INFINITY);
    }

    public DerivativeDTWDistanceFunction(double bandSize) {
        super(bandSize);
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim1 = v1.getDimensionality();
        int dim2 = v2.getDimensionality();
        int m2 = dim2 - 1;
        int band = this.effectiveBandSize(dim1, dim2);
        if (Math.abs(dim1 - dim2) > band) {
            return Double.POSITIVE_INFINITY;
        }
        double[] buf = new double[dim2 << 1];
        Arrays.fill(buf, Double.POSITIVE_INFINITY);
        this.firstRow(buf, band, v1, v2, dim2);
        int cur = 0;
        int nxt = dim2;
        int i = 1;
        int l = 0;
        int r = Math.min(m2, i + band);
        while (i < dim1) {
            double val1 = this.derivative(i, v1);
            for (int j = l; j <= r; ++j) {
                double min = buf[cur + j];
                if (j > 0) {
                    double pij = buf[cur + j - 1];
                    double d = min = pij < min ? pij : min;
                    if (j > l) {
                        double pj = buf[nxt + j - 1];
                        min = pj < min ? pj : min;
                    }
                }
                buf[nxt + j] = min + this.delta(val1, this.derivative(j, v2));
            }
            cur = dim2 - cur;
            nxt = dim2 - nxt;
            if (++i > band) {
                ++l;
            }
            if (r >= m2) continue;
            ++r;
        }
        return FastMath.sqrt(buf[cur + dim2 - 1]);
    }

    @Override
    protected void firstRow(double[] buf, int band, NumberVector v1, NumberVector v2, int dim2) {
        double val1 = this.derivative(0, v1);
        buf[0] = this.delta(val1, this.derivative(0, v2));
        int w = band >= dim2 ? dim2 - 1 : band;
        for (int j = 1; j <= w; ++j) {
            buf[j] = buf[j - 1] + this.delta(val1, this.derivative(j, v2));
        }
    }

    protected double derivative(int i, NumberVector v) {
        int dim = v.getDimensionality();
        if (dim == 1) {
            return 0.0;
        }
        i = i == 0 ? 1 : (i == dim - 1 ? dim - 2 : i);
        return (v.doubleValue(i) - v.doubleValue(i - 1) + (v.doubleValue(i + 1) - v.doubleValue(i - 1)) * 0.5) * 0.5;
    }
}

