/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.AbstractEditDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.DTWDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Title(value="Edit Distance on Real Sequence")
@Reference(authors="L. Chen, M. T. \u00d6zsu, V. Oria", title="Robust and fast similarity search for moving object trajectories", booktitle="Proc. 2005 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/1066157.1066213", bibkey="DBLP:conf/sigmod/ChenOO05")
public class EDRDistanceFunction
extends DTWDistanceFunction {
    private final double delta;

    public EDRDistanceFunction(double bandSize, double delta) {
        super(bandSize);
        this.delta = delta;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim1 = v1.getDimensionality();
        int dim2 = v2.getDimensionality();
        int band = this.effectiveBandSize(dim1, dim2);
        if (Math.abs(dim1 - dim2) > band) {
            return Double.POSITIVE_INFINITY;
        }
        double[] buf = new double[dim2 << 1];
        Arrays.fill(buf, Double.POSITIVE_INFINITY);
        this.firstRow(buf, band, v1, v2, dim2);
        int m2 = dim2 - 1;
        int cur = 0;
        int nxt = dim2;
        int i = 1;
        int l = 0;
        int r = Math.min(m2, i + band);
        while (i < dim1) {
            double val1 = v1.doubleValue(i);
            for (int j = l; j <= r; ++j) {
                double min = buf[cur + j];
                if (j > 0) {
                    double pij = buf[cur + j - 1];
                    double d = min = pij < min ? pij : min;
                    if (j > l) {
                        double pj = buf[nxt + j - 1];
                        min = pj < min ? pj : min;
                    }
                }
                buf[nxt + j] = min + this.delta(val1, v2.doubleValue(j));
            }
            cur = dim2 - cur;
            nxt = dim2 - nxt;
            if (++i > band) {
                ++l;
            }
            if (r >= m2) continue;
            ++r;
        }
        return buf[cur + dim2 - 1];
    }

    @Override
    protected double delta(double val1, double val2) {
        return Math.abs(val1 - val2) < this.delta ? 0.0 : 1.0;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.delta == ((EDRDistanceFunction)obj).delta;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Double.hashCode(this.delta);
    }

    public static class Parameterizer
    extends AbstractEditDistanceFunction.Parameterizer {
        public static final OptionID DELTA_ID = new OptionID("edr.delta", "the delta parameter (similarity threshold) for EDR (positive number)");
        protected double delta = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(DELTA_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(deltaP)) {
                this.delta = deltaP.doubleValue();
            }
        }

        public static double getParameterDelta(Parameterization config) {
            return 0.0;
        }

        @Override
        protected EDRDistanceFunction makeInstance() {
            return new EDRDistanceFunction(this.bandSize, this.delta);
        }
    }
}

