/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.AbstractEditDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.DTWDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;
import net.jafama.FastMath;

@Title(value="Edit Distance with Real Penalty")
@Reference(authors="L. Chen, R. Ng", title="On the marriage of Lp-norms and edit distance", booktitle="Proc. 13th Int. Conf. on Very Large Data Bases (VLDB '04)", url="http://www.vldb.org/conf/2004/RS21P2.PDF", bibkey="DBLP:conf/vldb/ChenN04")
public class ERPDistanceFunction
extends DTWDistanceFunction {
    private final double g;

    public ERPDistanceFunction(double bandSize, double g) {
        super(bandSize);
        this.g = g;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim1 = v1.getDimensionality();
        int dim2 = v2.getDimensionality();
        int m2 = dim2 - 1;
        int band = this.effectiveBandSize(dim1, dim2);
        if (Math.abs(dim1 - dim2) > band) {
            return Double.POSITIVE_INFINITY;
        }
        double[] buf = new double[dim2 << 1];
        Arrays.fill(buf, Double.POSITIVE_INFINITY);
        this.firstRow(buf, band, v1, v2, dim2);
        int cur = 0;
        int nxt = dim2;
        int i = 1;
        int l = 0;
        int r = Math.min(m2, i + band);
        while (i < dim1) {
            double val1 = v1.doubleValue(i);
            for (int j = l; j <= r; ++j) {
                double min = buf[cur + j] + this.delta(val1, this.g);
                if (j > 0) {
                    double pij = buf[cur + j - 1] + this.delta(val1, v2.doubleValue(j));
                    double d = min = pij < min ? pij : min;
                    if (j > l) {
                        double pj = buf[nxt + j - 1] + this.delta(this.g, v2.doubleValue(j));
                        min = pj < min ? pj : min;
                    }
                }
                buf[nxt + j] = min;
            }
            cur = dim2 - cur;
            nxt = dim2 - nxt;
            if (++i > band) {
                ++l;
            }
            if (r >= m2) continue;
            ++r;
        }
        return FastMath.sqrt(buf[cur + dim2 - 1]);
    }

    @Override
    protected void firstRow(double[] buf, int band, NumberVector v1, NumberVector v2, int dim2) {
        double val1 = v1.doubleValue(0);
        buf[0] = Math.min(this.delta(val1, this.g), this.delta(val1, v2.doubleValue(0)));
        int w = band >= dim2 ? dim2 - 1 : band;
        for (int j = 1; j <= w; ++j) {
            buf[j] = Math.min(this.delta(val1, this.g), buf[j - 1]) + this.delta(val1, v2.doubleValue(j));
        }
    }

    @Override
    protected double delta(double val1, double val2) {
        double diff = val1 - val2;
        return diff * diff;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.g == ((ERPDistanceFunction)obj).g;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Double.hashCode(this.g);
    }

    public static class Parameterizer
    extends AbstractEditDistanceFunction.Parameterizer {
        public static final OptionID G_ID = new OptionID("erp.g", "The g parameter of ERP - comparison value to use in gaps.");
        protected double g = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter gP = new DoubleParameter(G_ID, 0.0);
            if (config.grab(gP)) {
                this.g = gP.doubleValue();
            }
        }

        @Override
        protected ERPDistanceFunction makeInstance() {
            return new ERPDistanceFunction(this.bandSize, this.g);
        }
    }
}

