/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Longest Common Subsequence distance function")
@Reference(authors="M. Vlachos, M. Hadjieleftheriou, D. Gunopulos, E. Keogh", title="Indexing Multi-Dimensional Time-Series with Support for Multiple Distance Measures", booktitle="Proc. 9th ACM SIGKDD Int. Conf. on Knowledge Discovery and Data Mining", url="https://doi.org/10.1145/956750.956777", bibkey="DBLP:conf/kdd/VlachosHGK03")
public class LCSSDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    private double pDelta;
    private double pEpsilon;

    public LCSSDistanceFunction(double pDelta, double pEpsilon) {
        this.pDelta = pDelta;
        this.pEpsilon = pEpsilon;
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        if (dim1 > (dim2 = v2.getDimensionality())) {
            return this.distance(v2, v1);
        }
        int delta = (int)Math.ceil((double)dim2 * this.pDelta);
        double epsilon = this.getRange(v1, dim1, v2, dim2) * this.pEpsilon;
        double[] curr = new double[dim2 + 1];
        double[] next = new double[dim2 + 1];
        for (int i = 0; i < dim1; ++i) {
            double ai = v1.doubleValue(i);
            for (int j = Math.max(0, i - delta); j <= Math.min(dim2 - 1, i + delta); ++j) {
                double bj = v2.doubleValue(j);
                next[j + 1] = bj + epsilon >= ai && bj - epsilon <= ai ? curr[j] + 1.0 : (curr[j + 1] > next[j] ? curr[j + 1] : next[j]);
            }
            double[] tmp = curr;
            curr = next;
            next = tmp;
        }
        double maxEntry = curr[1];
        for (int i = 2; i < dim2 + 1; ++i) {
            maxEntry = curr[i] > maxEntry ? curr[i] : maxEntry;
        }
        double sim = maxEntry / (double)Math.min(dim1, dim2);
        return 1.0 - sim;
    }

    public double getRange(NumberVector v1, int dim1, NumberVector v2, int dim2) {
        double v;
        int i;
        double min;
        double max = min = v1.doubleValue(0);
        for (i = 1; i < dim1; ++i) {
            v = v1.doubleValue(i);
            min = v < min ? v : min;
            max = v > max ? v : max;
        }
        for (i = 0; i < dim2; ++i) {
            v = v2.doubleValue(i);
            min = v < min ? v : min;
            max = v > max ? v : max;
        }
        double range = max - min;
        return range;
    }

    @Override
    public VectorTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.VARIABLE_LENGTH;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && this.getClass().equals(obj.getClass()) && this.pDelta == ((LCSSDistanceFunction)obj).pDelta && this.pEpsilon == ((LCSSDistanceFunction)obj).pEpsilon;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Double.hashCode(this.pDelta) * 31 + Double.hashCode(this.pEpsilon);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PDELTA_ID = new OptionID("lcss.pDelta", "the allowed deviation in x direction for LCSS alignment (positive double value, 0 <= pDelta <= 1)");
        public static final OptionID PEPSILON_ID = new OptionID("lcss.pEpsilon", "the allowed deviation in y direction for LCSS alignment (positive double value, 0 <= pEpsilon <= 1)");
        private double pDelta;
        private double pEpsilon;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter pEpsilonP;
            super.makeOptions(config);
            DoubleParameter pDeltaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(PDELTA_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (config.grab(pDeltaP)) {
                this.pDelta = pDeltaP.doubleValue();
            }
            if (config.grab(pEpsilonP = (DoubleParameter)((DoubleParameter)new DoubleParameter(PEPSILON_ID, 0.05).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.pEpsilon = pEpsilonP.doubleValue();
            }
        }

        @Override
        protected LCSSDistanceFunction makeInstance() {
            return new LCSSDistanceFunction(this.pDelta, this.pEpsilon);
        }
    }
}

